/*
 * Decompiled with CFR 0.152.
 */
package com.cherry.sdk.controller;

import android.util.Log;
import com.cherry.sdk.controller.InitDevice;
import com.cherry.sdk.controller.LightManager;
import com.cherry.sdk.controller.SerialController;
import com.cherry.sdk.controller.callback.CmdCallback;
import com.cherry.sdk.controller.command.Command;
import com.cherry.sdk.controller.data.PackageConfig;
import com.cherry.sdk.controller.utils.SerialDataUtils;
import java.util.Collections;
import org.json.JSONException;

public class MoternDeviceController {
    private static final String TAG = "MoternDeviceController";
    private static final MoternDeviceController instance = new MoternDeviceController();
    private static final int CMD_QUERY_VERSION = 1;
    private static final int CMD_UNLOCK_LOCKER = 2;
    private static final int CMD_UNLOCK_SECTION = 3;
    private static final int CMD_QUERY_LOCKER = 4;
    private static final int CMD_QUERY_SECTION = 5;
    private static final int CMD_RELAY_OPT = 16;
    private static final int FOOD_QUERY_VERSION = 17;
    private static final int FOOD_UNLOCK_LOCKER = 18;
    private static final int FOOD_UNLOCK_SECTION = 19;
    private static final int FOOD_QUERY_LOCKER = 20;
    private static final int FOOD_QUERY_SECTION = 21;
    private static final int FOOD_HOT_LOCKER = 34;
    private static final int FOOD_HOT_SECTION = 35;
    private static final int FOOD_DEGAS_LOCKER = 38;
    private static final int FOOD_DEGAS_SECTION = 39;
    private static String head;
    private static String tail;
    private InitDevice mInitDevice;
    private int mBoardType;
    private LightManager mLightManager = new LightManager();

    public static MoternDeviceController getInstance() {
        return instance;
    }

    public void init(InitDevice device) {
        this.mInitDevice = device;
        this.mBoardType = this.mInitDevice.getBoardType();
        if (PackageConfig.head == 85) {
            head = "55";
            tail = "EF";
        } else {
            head = "AA";
            tail = "DF";
        }
    }

    public void queryVersion(int section, final CmdCallback callback) {
        int cmd = head.equals("55") ? 17 : 1;
        String body = String.format(head + "%02x%02x%02x0000000000000000", section, 0, cmd);
        byte lrc = Command.generateLRC(SerialDataUtils.HexToByteArr(body));
        String data = body + SerialDataUtils.Byte2Hex(lrc) + tail;
        SerialController.getInstance().send(new Command(Collections.singletonList(data), new Command.Callback(){

            @Override
            public void handleResult(int code, byte[][] bys) {
                String result = "";
                try {
                    result = SerialDataUtils.ByteArrToHex(bys[0]);
                }
                catch (Exception e) {
                    Log.d((String)MoternDeviceController.TAG, (String)("queryVersion: " + e));
                }
                callback.onMessage(code, result);
            }
        }));
    }

    public void unlockLocker(int section, int port, final CmdCallback callback) {
        int cmd = head.equals("55") ? 18 : 2;
        String body = String.format(head + "%02x%02x%02x0000000000000000", section, port, cmd);
        byte lrc = Command.generateLRC(SerialDataUtils.HexToByteArr(body));
        String data = body + SerialDataUtils.Byte2Hex(lrc) + tail;
        SerialController.getInstance().send(new Command(Collections.singletonList(data), new Command.Callback(){

            @Override
            public void handleResult(int code, byte[][] bys) {
                callback.onMessage(code, new String[0]);
            }
        }));
    }

    public void setFaceLight(int mode, CmdCallback callback) {
        if (this.mBoardType == InitDevice.getZh_v01()) {
            this.mLightManager.setLedMode(mode);
        } else {
            callback.onMessage(1801, new String[0]);
        }
    }

    public void queryLocker(int section, int port, final CmdCallback callback) {
        int cmd = head.equals("55") ? 20 : 4;
        String body = String.format(head + "%02x%02x%02x0000000000000000", section, port, cmd);
        byte lrc = Command.generateLRC(SerialDataUtils.HexToByteArr(body));
        String data = body + SerialDataUtils.Byte2Hex(lrc) + tail;
        SerialController.getInstance().send(new Command(Collections.singletonList(data), new Command.Callback(){

            @Override
            public void handleResult(int code, byte[][] bys) {
                String status = "locked";
                try {
                    byte[] raw = bys[0];
                    if (code == 0) {
                        status = raw[4] == 0 ? "locked" : "unlocked";
                    }
                }
                catch (Exception e) {
                    Log.d((String)MoternDeviceController.TAG, (String)("handleResult: " + e));
                }
                callback.onMessage(code, status);
            }
        }));
    }

    public void querySection(int section, final CmdCallback callback) {
        int cmd = head.equals("55") ? 21 : 5;
        String body = String.format(head + "%02x%02x%02x0000000000000000", section, 0, cmd);
        byte lrc = Command.generateLRC(SerialDataUtils.HexToByteArr(body));
        String data = body + SerialDataUtils.Byte2Hex(lrc) + tail;
        SerialController.getInstance().send(new Command(Collections.singletonList(data), new Command.Callback(){

            @Override
            public void handleResult(int code, byte[][] bys) {
                String result = "";
                try {
                    if (code == 0) {
                        byte[] raw = bys[0];
                        result = SerialDataUtils.hexStr2Arr(raw);
                    }
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
                callback.onMessage(code, result);
            }
        }));
    }

    public void unlockSection(int section, final CmdCallback callback) {
        int cmd = head.equals("55") ? 19 : 3;
        String body = String.format(head + "%02x%02x%02x0000000000000000", section, 1, cmd);
        byte lrc = Command.generateLRC(SerialDataUtils.HexToByteArr(body));
        String data = body + SerialDataUtils.Byte2Hex(lrc) + tail;
        SerialController.getInstance().send(new Command(Collections.singletonList(data), new Command.Callback(){

            @Override
            public void handleResult(int code, byte[][] bys) {
                String result = "";
                try {
                    result = SerialDataUtils.ByteArrToHex(bys[0]);
                }
                catch (Exception e) {
                    Log.d((String)MoternDeviceController.TAG, (String)("queryVersion: " + e));
                }
                callback.onMessage(code, result);
            }
        }));
    }

    public void relayOpt(int section, int port, int opt, final CmdCallback callback) {
        if (this.mBoardType != InitDevice.getXt_v01()) {
            callback.onMessage(1801, new String[0]);
            return;
        }
        String body = String.format(head + "%02x%02x10%02x%02x000000000000", section, port, 16, opt);
        byte lrc = Command.generateLRC(SerialDataUtils.HexToByteArr(body));
        String data = body + SerialDataUtils.Byte2Hex(lrc) + tail;
        SerialController.getInstance().send(new Command(Collections.singletonList(data), new Command.Callback(){

            @Override
            public void handleResult(int code, byte[][] bys) {
                callback.onMessage(code, new String[0]);
            }
        }));
    }

    public void hotLocker(int section, int port, int opt, final CmdCallback callback) {
        if (this.mBoardType != InitDevice.getXt_v02()) {
            callback.onMessage(1801, new String[0]);
            return;
        }
        String body = String.format(head + "%02x%02x%02x%02x00000000000000", section, port, 34, opt);
        byte lrc = Command.generateLRC(SerialDataUtils.HexToByteArr(body));
        String data = body + SerialDataUtils.Byte2Hex(lrc) + tail;
        SerialController.getInstance().send(new Command(Collections.singletonList(data), new Command.Callback(){

            @Override
            public void handleResult(int code, byte[][] bys) {
                callback.onMessage(code, new String[0]);
            }
        }));
    }

    public void hotSection(int section, int opt, final CmdCallback callback) {
        if (this.mBoardType != InitDevice.getXt_v02()) {
            callback.onMessage(1801, new String[0]);
            return;
        }
        String body = String.format(head + "%02x%02x%02x%02x00000000000000", section, 0, 34, opt);
        byte lrc = Command.generateLRC(SerialDataUtils.HexToByteArr(body));
        String data = body + SerialDataUtils.Byte2Hex(lrc) + tail;
        SerialController.getInstance().send(new Command(Collections.singletonList(data), new Command.Callback(){

            @Override
            public void handleResult(int code, byte[][] bys) {
                callback.onMessage(code, new String[0]);
            }
        }));
    }

    public void degasLocker(int section, int port, int opt, final CmdCallback callback) {
        if (this.mBoardType != InitDevice.getXt_v02()) {
            callback.onMessage(1801, new String[0]);
            return;
        }
        String body = String.format(head + "%02x%02x%02x%02x00000000000000", section, port, 38, opt);
        byte lrc = Command.generateLRC(SerialDataUtils.HexToByteArr(body));
        String data = body + SerialDataUtils.Byte2Hex(lrc) + tail;
        SerialController.getInstance().send(new Command(Collections.singletonList(data), new Command.Callback(){

            @Override
            public void handleResult(int code, byte[][] bys) {
                callback.onMessage(code, new String[0]);
            }
        }));
    }

    public void setFoodDegasSection(int section, int opt, final CmdCallback callback) {
        if (this.mBoardType != InitDevice.getXt_v02()) {
            callback.onMessage(1801, new String[0]);
            return;
        }
        String body = String.format(head + "%02x%02x%02x%02x00000000000000", section, 0, 39, opt);
        byte lrc = Command.generateLRC(SerialDataUtils.HexToByteArr(body));
        String data = body + SerialDataUtils.Byte2Hex(lrc) + tail;
        SerialController.getInstance().send(new Command(Collections.singletonList(data), new Command.Callback(){

            @Override
            public void handleResult(int code, byte[][] bys) {
                callback.onMessage(code, new String[0]);
            }
        }));
    }

    public void optCommand(String cmd, final CmdCallback callback) {
        SerialController.getInstance().send(new Command(Collections.singletonList(cmd), new Command.Callback(){

            @Override
            public void handleResult(int code, byte[][] bys) {
                String result = "";
                try {
                    result = SerialDataUtils.ByteArrToHex(bys[0]);
                }
                catch (Exception e) {
                    Log.d((String)MoternDeviceController.TAG, (String)("queryVersion: " + e));
                }
                callback.onMessage(code, result);
            }
        }));
    }
}

