/*
 * Decompiled with CFR 0.152.
 */
package com.cherry.sdk.controller;

import android.util.Log;
import com.cherry.sdk.controller.data.PackageConfig;
import com.cherry.sdk.controller.data.SerialCompat;

public class InitDevice {
    private final int boardType;
    private static final int xt_v01 = 1;
    private static final int xt_v02 = 2;
    private static final int zh_v01 = 3;
    private static final int sx_v01 = 4;
    private static final int rx_v01 = 5;
    private static final int k22_g20 = 6;
    private static final int s905 = 7;

    public InitDevice(int boardType) {
        this.boardType = boardType;
        PackageConfig.bandRate = 9600;
        PackageConfig.head = (byte)-86;
        PackageConfig.tail = (byte)-33;
        PackageConfig.length = SerialCompat.BIT_WIDTH;
        PackageConfig.uartRtsIO = SerialCompat.RW_CONTROL_IO_A;
        PackageConfig.revertUartRts = SerialCompat.REVERUART_RTS;
        switch (boardType) {
            case 1: {
                PackageConfig.device_485 = SerialCompat.DEVICE_485_A;
                break;
            }
            case 2: {
                PackageConfig.device_485 = SerialCompat.DEVICE_485_A;
                PackageConfig.head = (byte)85;
                PackageConfig.tail = (byte)-17;
                break;
            }
            case 5: {
                PackageConfig.device_485 = SerialCompat.DEVICE_485_P;
                break;
            }
            case 4: {
                PackageConfig.uartRtsIO = -1;
                PackageConfig.device_485 = SerialCompat.DEVICE_485_SX;
                break;
            }
            case 3: {
                PackageConfig.device_485 = SerialCompat.DEVICE_485_ZH;
                break;
            }
            case 6: {
                PackageConfig.uartRtsIO = 0;
                PackageConfig.head = (byte)85;
                PackageConfig.tail = (byte)-17;
                PackageConfig.device_485 = SerialCompat.DEVICE_485_ZH;
                break;
            }
            case 7: {
                PackageConfig.device_485 = SerialCompat.DEVICE_485_S905;
                PackageConfig.uartRtsIO = -1;
                PackageConfig.head = (byte)-85;
                PackageConfig.revertUartRts = false;
                break;
            }
            default: {
                Log.d((String)"InitDevice", (String)"init: default");
                PackageConfig.device_485 = SerialCompat.DEVICE_485_A;
            }
        }
    }

    public int getBoardType() {
        return this.boardType;
    }

    public static int getRx_v01() {
        return 5;
    }

    public static int getSx_v01() {
        return 4;
    }

    public static int getXt_v01() {
        return 1;
    }

    public static int getXt_v02() {
        return 2;
    }

    public static int getZh_v01() {
        return 3;
    }
}

