/*
 * Decompiled with CFR 0.152.
 */
package com.cherry.sdk.controller.command;

import androidx.annotation.Nullable;
import com.cherry.sdk.controller.data.SerialCompat;
import com.cherry.sdk.controller.utils.SerialDataUtils;
import java.util.List;

public class Command {
    public byte[][] bys;
    public Callback callback;

    public Command(List<String> commandList, Callback callback) {
        this.bys = this.parse(commandList);
        this.callback = callback;
    }

    private byte[][] parse(List<String> commandList) {
        int cmdCount = commandList.size();
        byte[][] bys = new byte[cmdCount][SerialCompat.BIT_WIDTH];
        for (int i = 0; i < cmdCount; ++i) {
            bys[i] = SerialDataUtils.HexToByteArr(commandList.get(i));
        }
        return bys;
    }

    public static byte generateLRC(byte[] data) {
        return SerialCompat.generateLRC(data);
    }

    public static boolean checkLRC(byte[] data) {
        return SerialCompat.checkLRC(data);
    }

    public static interface Callback {
        public void handleResult(int var1, @Nullable byte[][] var2);
    }
}

