/*
 * Decompiled with CFR 0.152.
 */
package com.cherry.sdk.controller.utils;

import android.bluetooth.BluetoothAdapter;
import android.os.Handler;
import android.view.KeyEvent;
import com.cherry.sdk.controller.callback.OnScanListen;

public class ScanGunKeyEventHelper {
    private static final long MESSAGE_DELAY = 1000L;
    private StringBuffer mStringBufferResult;
    private boolean mCaps;
    private final Handler mHandler;
    private final BluetoothAdapter mBluetoothAdapter;
    private final Runnable mScanningFishedRunnable;
    private OnScanListen mOnScanSuccessListener;
    private String mDeviceName;
    private static final String TAG = ScanGunKeyEventHelper.class.getSimpleName();

    public ScanGunKeyEventHelper(OnScanListen onScanSuccessListener) {
        this.mOnScanSuccessListener = onScanSuccessListener;
        this.mBluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
        this.mStringBufferResult = new StringBuffer();
        this.mHandler = new Handler();
        this.mScanningFishedRunnable = new Runnable(){

            @Override
            public void run() {
                ScanGunKeyEventHelper.this.performScanSuccess();
            }
        };
    }

    private void performScanSuccess() {
        String barcode = this.mStringBufferResult.toString();
        if (this.mOnScanSuccessListener != null) {
            this.mOnScanSuccessListener.onScanSuccess(barcode);
        }
        this.mStringBufferResult.setLength(0);
    }

    public void analysisKeyEvent(KeyEvent event) {
        int keyCode = event.getKeyCode();
        this.checkLetterStatus(event);
        if (event.getAction() == 0) {
            char aChar = this.getInputCode(event);
            if (aChar != '\u0000') {
                this.mStringBufferResult.append(aChar);
            }
            if (keyCode == 66) {
                this.mHandler.removeCallbacks(this.mScanningFishedRunnable);
                this.mHandler.post(this.mScanningFishedRunnable);
            } else {
                this.mHandler.removeCallbacks(this.mScanningFishedRunnable);
                this.mHandler.postDelayed(this.mScanningFishedRunnable, 1000L);
            }
        }
    }

    private void checkLetterStatus(KeyEvent event) {
        int keyCode = event.getKeyCode();
        if (keyCode == 60 || keyCode == 59) {
            this.mCaps = event.getAction() == 0;
        }
    }

    private char getInputCode(KeyEvent event) {
        int aChar;
        int keyCode = event.getKeyCode();
        if (keyCode >= 29 && keyCode <= 54) {
            aChar = (char)((this.mCaps ? 65 : 97) + keyCode - 29);
        } else if (keyCode >= 7 && keyCode <= 16) {
            aChar = (char)(48 + keyCode - 7);
        } else if (keyCode == 71) {
            aChar = this.mCaps ? 123 : 91;
        } else if (keyCode == 72) {
            aChar = this.mCaps ? 125 : 93;
        } else if (keyCode == 74) {
            aChar = this.mCaps ? 58 : 59;
        } else {
            switch (keyCode) {
                case 55: {
                    aChar = 44;
                    break;
                }
                case 56: {
                    aChar = 46;
                    break;
                }
                case 69: {
                    aChar = this.mCaps ? 95 : 45;
                    break;
                }
                case 76: {
                    aChar = 47;
                    break;
                }
                case 73: {
                    aChar = this.mCaps ? 124 : 92;
                    break;
                }
                default: {
                    aChar = 0;
                }
            }
        }
        return (char)aChar;
    }

    public void onDestroy() {
        this.mHandler.removeCallbacks(this.mScanningFishedRunnable);
        this.mOnScanSuccessListener = null;
    }
}

