/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.spring.web.scanners;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import springfox.documentation.PathProvider;
import springfox.documentation.builders.DocumentationBuilder;
import springfox.documentation.builders.ResourceListingBuilder;
import springfox.documentation.service.ApiListing;
import springfox.documentation.service.ApiListingReference;
import springfox.documentation.service.Documentation;
import springfox.documentation.service.ResourceListing;
import springfox.documentation.service.Tags;
import springfox.documentation.spi.service.contexts.DocumentationContext;
import springfox.documentation.spi.service.contexts.Orderings;
import springfox.documentation.spring.web.paths.PathMappingAdjuster;
import springfox.documentation.spring.web.scanners.ApiListingReferenceScanResult;
import springfox.documentation.spring.web.scanners.ApiListingReferenceScanner;
import springfox.documentation.spring.web.scanners.ApiListingScanner;
import springfox.documentation.spring.web.scanners.ApiListingScanningContext;

@Component
public class ApiDocumentationScanner {
    private ApiListingReferenceScanner apiListingReferenceScanner;
    private ApiListingScanner apiListingScanner;

    @Autowired
    public ApiDocumentationScanner(ApiListingReferenceScanner apiListingReferenceScanner, ApiListingScanner apiListingScanner) {
        this.apiListingReferenceScanner = apiListingReferenceScanner;
        this.apiListingScanner = apiListingScanner;
    }

    public Documentation scan(DocumentationContext context) {
        ApiListingReferenceScanResult result = this.apiListingReferenceScanner.scan(context);
        ApiListingScanningContext listingContext = new ApiListingScanningContext(context, result.getResourceGroupRequestMappings());
        Multimap<String, ApiListing> apiListings = this.apiListingScanner.scan(listingContext);
        DocumentationBuilder group = new DocumentationBuilder().name(context.getGroupName()).apiListingsByResourceGroupName(apiListings).produces(context.getProduces()).consumes(context.getConsumes()).host(context.getHost()).schemes(context.getProtocols()).basePath(context.getPathProvider().getApplicationBasePath()).tags(Tags.toTags(apiListings));
        TreeSet apiReferenceSet = Sets.newTreeSet((Comparator)Orderings.listingReferencePathComparator());
        apiReferenceSet.addAll(this.apiListingReferences(apiListings, context));
        ResourceListing resourceListing = new ResourceListingBuilder().apiVersion(context.getApiInfo().getVersion()).apis((List)FluentIterable.from((Iterable)apiReferenceSet).toSortedList((Comparator)context.getListingReferenceOrdering())).securitySchemes(context.getSecuritySchemes()).info(context.getApiInfo()).build();
        group.resourceListing(resourceListing);
        return group.build();
    }

    private Collection<? extends ApiListingReference> apiListingReferences(Multimap<String, ApiListing> apiListings, DocumentationContext context) {
        Map grouped = Multimaps.asMap(apiListings);
        return FluentIterable.from(grouped.entrySet()).transform(this.toApiListingReference(context)).toSet();
    }

    private Function<Map.Entry<String, Collection<ApiListing>>, ApiListingReference> toApiListingReference(final DocumentationContext context) {
        return new Function<Map.Entry<String, Collection<ApiListing>>, ApiListingReference>(){

            public ApiListingReference apply(Map.Entry<String, Collection<ApiListing>> input) {
                String description = Joiner.on((String)System.getProperty("line.separator")).join(ApiDocumentationScanner.this.descriptions(input.getValue()));
                PathMappingAdjuster adjuster = new PathMappingAdjuster(context);
                PathProvider pathProvider = context.getPathProvider();
                String path = pathProvider.getResourceListingPath(context.getGroupName(), input.getKey());
                return new ApiListingReference(adjuster.adjustedPath(path), description, 0);
            }
        };
    }

    private Iterable<String> descriptions(Collection<ApiListing> apiListings) {
        return FluentIterable.from(apiListings).transform(this.toDescription());
    }

    private Function<ApiListing, String> toDescription() {
        return new Function<ApiListing, String>(){

            public String apply(ApiListing input) {
                return input.getDescription();
            }
        };
    }
}

