/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.schema.property.bean;

import com.fasterxml.classmate.ResolvedType;
import com.fasterxml.classmate.TypeResolver;
import com.fasterxml.classmate.members.ResolvedMethod;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import springfox.documentation.schema.property.BaseModelProperty;
import springfox.documentation.schema.property.bean.Accessors;
import springfox.documentation.spi.schema.AlternateTypeProvider;

public class BeanModelProperty
extends BaseModelProperty {
    private static final Logger LOG = LoggerFactory.getLogger(BeanModelProperty.class);
    private final ResolvedMethod method;
    private TypeResolver typeResolver;

    public BeanModelProperty(String propertyName, ResolvedMethod method, TypeResolver typeResolver, AlternateTypeProvider alternateTypeProvider) {
        super(propertyName, alternateTypeProvider);
        this.method = method;
        this.typeResolver = typeResolver;
    }

    @Override
    protected ResolvedType realType() {
        return BeanModelProperty.paramOrReturnType(this.typeResolver, this.method);
    }

    private static ResolvedType adjustedToClassmateBug(TypeResolver typeResolver, ResolvedType resolvedType) {
        if (resolvedType.getErasedType().getTypeParameters().length > 0) {
            return resolvedType;
        }
        return typeResolver.resolve((Type)resolvedType.getErasedType(), new Type[0]);
    }

    public static ResolvedType paramOrReturnType(TypeResolver typeResolver, ResolvedMethod input) {
        if (Accessors.maybeAGetter((Method)input.getRawMember())) {
            LOG.debug("Evaluating unwrapped getter for member {}", (Object)((Method)input.getRawMember()).getName());
            return BeanModelProperty.adjustedToClassmateBug(typeResolver, input.getReturnType());
        }
        LOG.debug("Evaluating unwrapped setter for member {}", (Object)((Method)input.getRawMember()).getName());
        return BeanModelProperty.adjustedToClassmateBug(typeResolver, input.getArgumentType(0));
    }
}

