/*
 * Decompiled with CFR 0.152.
 */
package com.kmall.common.xss;

import com.kmall.common.xss.XssHttpServletRequestWrapper;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;

public class XssFilter
implements Filter {
    private String excludedPages;
    private String[] excludedPageArray;

    public void init(FilterConfig config) throws ServletException {
        this.excludedPages = config.getInitParameter("excludedPages");
        if (StringUtils.isNotEmpty((String)this.excludedPages)) {
            this.excludedPageArray = this.excludedPages.split(",");
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        XssHttpServletRequestWrapper xssRequest = new XssHttpServletRequestWrapper((HttpServletRequest)request);
        boolean isExcludedPage = false;
        for (String page : this.excludedPageArray) {
            if (!((HttpServletRequest)request).getServletPath().equals(page)) continue;
            isExcludedPage = true;
            break;
        }
        if (isExcludedPage) {
            chain.doFilter(request, response);
        } else {
            chain.doFilter((ServletRequest)xssRequest, response);
        }
    }

    public void destroy() {
    }
}

