/*
 * Decompiled with CFR 0.152.
 */
package com.kmall.common.utils.print.ticket;

import com.kmall.common.utils.print.ticket.TicketBuilder;
import com.kmall.common.utils.print.ticket.doc.PrintAttributeBuilder;
import com.kmall.common.utils.print.ticket.item.Ticket;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import javax.print.DocPrintJob;
import javax.print.PrintException;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.SimpleDoc;

public class TicketPrinter {
    public static void print(Ticket ticket) {
        try {
            PrinterJob job = PrinterJob.getPrinterJob();
            if (job.getPrintService() == null) {
                throw new PrinterException("\u6ca1\u6709\u9ed8\u8ba4\u6253\u5370\u673a");
            }
            TicketBuilder ticketBuilder = new TicketBuilder();
            if (ticket == null) {
                throw new PrinterException("\u65e0\u5bf9\u5e94\u5c0f\u7968\u4fe1\u606f");
            }
            ticketBuilder.setTicket(ticket);
            job.setPageable(ticketBuilder.getPage());
            job.print();
        }
        catch (PrinterException e) {
            e.printStackTrace();
        }
    }

    public static void print2(Ticket ticket) {
        PrintService pringService = PrintServiceLookup.lookupDefaultPrintService();
        if (pringService == null) {
            throw new RuntimeException("\u6ca1\u6709\u9ed8\u8ba4\u6253\u5370\u670d\u52a1");
        }
        DocPrintJob job = pringService.createPrintJob();
        if (job.getPrintService() == null) {
            throw new RuntimeException("\u6ca1\u6709\u9ed8\u8ba4\u6253\u5370\u673a");
        }
        PrintAttributeBuilder printAttr = new PrintAttributeBuilder();
        TicketBuilder ticketBuilder = new TicketBuilder();
        if (ticket == null) {
            throw new IllegalArgumentException("\u65e0\u5bf9\u5e94\u5c0f\u7968\u4fe1\u606f");
        }
        ticketBuilder.setTicket(ticket);
        SimpleDoc doc = new SimpleDoc(ticketBuilder, printAttr.buildDocFlavor(), printAttr.buildDocAttributeSet());
        try {
            job.print(doc, printAttr.buildPrintRequestAttributeSet());
        }
        catch (PrintException pe) {
            pe.printStackTrace();
        }
    }
}

