/*
 * Decompiled with CFR 0.152.
 */
package com.kmall.common.utils.print.ticket;

import com.kmall.common.utils.print.ticket.doc.PrintPageableBuilder;
import com.kmall.common.utils.print.ticket.item.Goods;
import com.kmall.common.utils.print.ticket.item.Ticket;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class TicketBuilder
implements Printable {
    private Ticket ticket;

    public Pageable getPage() {
        return new PrintPageableBuilder().buildPage(this);
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) throws PrinterException {
        Graphics2D g2 = (Graphics2D)graphics;
        g2.setColor(Color.black);
        double x = pageFormat.getImageableX() + 3.0;
        double y = pageFormat.getImageableY();
        float xIdx = (float)x;
        float yIdx = (float)y;
        Font fontTit = new Font(this.ticket.getTicketHeadFont().getFamily(), this.ticket.getTicketHeadFont().getWeight(), this.ticket.getTicketHeadFont().getSize());
        g2.setFont(fontTit);
        float fontHeigthTit = fontTit.getSize2D();
        g2.drawString(this.ticket.getTicketHead().getTitle(), xIdx + 50.0f, yIdx += fontHeigthTit);
        Font font = new Font(this.ticket.getTicketCommonFont().getFamily(), this.ticket.getTicketCommonFont().getWeight(), this.ticket.getTicketCommonFont().getSize());
        g2.setFont(font);
        float fontHeigth = font.getSize2D();
        float line = fontHeigth + 2.0f;
        xIdx = (float)x;
        yIdx += line + 2.0f;
        g2.drawString("\u4f1a\u5458:" + this.ticket.getTicketHead().getMemberId(), xIdx, yIdx += line);
        g2.drawString("\u8ba2\u5355\u53f7:" + this.ticket.getTicketHead().getOrderId(), xIdx, yIdx += line);
        g2.drawString("\u4ea4\u6613\u65f6\u95f4:" + this.ticket.getTicketHead().getTradeTime(), xIdx, yIdx += line);
        g2.setStroke(new BasicStroke(0.4f, 0, 0, 4.0f, new float[]{4.0f, 2.0f, 1.0f, 2.0f}, 0.0f));
        g2.drawLine((int)x, (int)(yIdx += line - 2.0f), (int)(xIdx + 200.0f), (int)yIdx);
        int gnInd = 4;
        Font fontGoodsTit = new Font(this.ticket.getTicketGoodsTitleFont().getFamily(), this.ticket.getTicketGoodsTitleFont().getWeight(), this.ticket.getTicketGoodsTitleFont().getSize());
        g2.setFont(fontGoodsTit);
        float fontHeigthGoodsTit = fontGoodsTit.getSize2D();
        float lineGoodsTit = fontHeigthGoodsTit + 2.0f;
        g2.drawString("\u5546\u54c1\u540d\u79f0", xIdx, yIdx += lineGoodsTit + 2.0f);
        g2.drawString("\u5355\u4ef7", xIdx + 100.0f + (float)gnInd, yIdx);
        g2.drawString("\u6570\u91cf", xIdx + 130.0f + (float)gnInd, yIdx);
        g2.drawString("\u5c0f\u8ba1", xIdx + 160.0f + (float)gnInd, yIdx);
        g2.setFont(font);
        g2.drawLine((int)x, (int)(yIdx += line - 3.0f), (int)(xIdx + 200.0f), (int)yIdx);
        List<Goods> goodsList = this.ticket.getGoods();
        if (goodsList != null && goodsList.size() > 0) {
            int i = 0;
            for (Goods gdf : goodsList) {
                ++i;
                List<String> gnameL = this.detachString(gdf.getGname(), 12);
                int gname = gnameL.size();
                if (gname <= 0) continue;
                for (int j = 0; j < gname; ++j) {
                    if (this.ticket.getGoodsAlign().equalsIgnoreCase("top")) {
                        if (j == 0) {
                            g2.drawString("#" + gnameL.get(j), xIdx, yIdx += line + 3.0f);
                            g2.drawString(gdf.getUprice(), xIdx + 100.0f + (float)gnInd, yIdx);
                            g2.drawString(gdf.getNum(), xIdx + 130.0f + (float)gnInd, yIdx);
                            g2.drawString(gdf.getSubtotal() + "\u5143", xIdx + 160.0f + (float)gnInd, yIdx);
                            continue;
                        }
                        g2.drawString(String.valueOf(gnameL.get(j)), xIdx + (float)gnInd, yIdx += line);
                        continue;
                    }
                    if (j < gname - 1) {
                        if (j == 0) {
                            g2.drawString("#" + gnameL.get(j), xIdx, yIdx += line + 5.0f);
                            continue;
                        }
                        g2.drawString(String.valueOf(gnameL.get(j)), xIdx + (float)gnInd, yIdx += line);
                        continue;
                    }
                    g2.drawString(String.valueOf(gnameL.get(j)), xIdx + (float)gnInd, yIdx += line);
                    g2.drawString(gdf.getUprice(), xIdx + 100.0f + (float)gnInd, yIdx);
                    g2.drawString(gdf.getNum(), xIdx + 130.0f + (float)gnInd, yIdx);
                    g2.drawString(gdf.getSubtotal() + "\u5143", xIdx + 160.0f + (float)gnInd, yIdx);
                }
            }
        }
        g2.drawLine((int)x, (int)(yIdx += line), (int)(xIdx + 200.0f), (int)yIdx);
        g2.drawString("\u5546\u54c1\u5408\u8ba1:", xIdx, yIdx += line + 2.0f);
        g2.drawString(this.ticket.getCashInfo().getGoodsTotal() + "\u4ef6", xIdx + 130.0f + (float)gnInd, yIdx);
        g2.drawString(this.ticket.getCashInfo().getTotal() + "\u5143", xIdx + 160.0f + (float)gnInd, yIdx);
        g2.drawString("\u5b9e\u6536:", xIdx, yIdx += line);
        g2.drawString(this.ticket.getCashInfo().getReceipts() + "\u5143", xIdx + 160.0f + (float)gnInd, yIdx);
        g2.drawString("\u627e\u96f6:", xIdx, yIdx += line);
        g2.drawString(this.ticket.getCashInfo().getOddChange() + "\u5143", xIdx + 160.0f + (float)gnInd, yIdx);
        g2.drawString("\u4f18\u60e0\u5238:", xIdx, yIdx += line);
        g2.drawString(this.ticket.getCashInfo().getCoupon() + "\u5143", xIdx + 160.0f + (float)gnInd, yIdx);
        g2.drawString("\u8fd0\u8d39:", xIdx, yIdx += line);
        g2.drawString(this.ticket.getCashInfo().getFreight() + "\u5143", xIdx + 160.0f + (float)gnInd, yIdx);
        g2.drawString("\u652f\u4ed8\u6e20\u9053:", xIdx, yIdx += line);
        g2.drawString(this.ticket.getCashInfo().getPaymentMode(), xIdx + 160.0f + (float)gnInd, yIdx);
        g2.drawLine((int)x, (int)(yIdx += line - 1.0f), (int)(xIdx + 200.0f), (int)yIdx);
        g2.drawString("\u8ba2\u5355\u53f7:" + this.ticket.getCusListing().getOrderId(), xIdx, yIdx += line + 2.0f);
        g2.drawString("\u8fd0\u5355\u7f16\u53f7:" + this.ticket.getCusListing().getWaybillId(), xIdx, yIdx += line);
        g2.drawString("\u6d77\u5173\u6e05\u5355\u53f7:" + this.ticket.getCusListing().getInvtNo(), xIdx, yIdx += line);
        g2.drawString("\u6536\u8d27\u4eba:" + this.ticket.getCusListing().getConsignee(), xIdx, yIdx += line);
        g2.drawString("\u6536\u8d27\u4eba\u7535\u8bdd:" + this.ticket.getCusListing().getConsigneeTel(), xIdx, yIdx += line);
        g2.drawString("\u59cb\u53d1\u5730:" + this.ticket.getCusListing().getOriginAddress(), xIdx, yIdx += line);
        yIdx += line;
        List<String> addressList = this.detachString(this.ticket.getCusListing().getDeliveryAddress(), 20);
        for (int i = 0; i < addressList.size(); ++i) {
            if (i == 0) {
                g2.drawString("\u4ea4\u8d27\u5730:" + addressList.get(i), xIdx, yIdx);
                continue;
            }
            g2.drawString(addressList.get(i), xIdx + 30.0f, yIdx += line);
        }
        g2.drawLine((int)x, (int)(yIdx += line - 1.0f), (int)(xIdx + 200.0f), (int)yIdx);
        if (!StringUtils.isBlank((CharSequence)this.ticket.getTicketFoot().getSummary())) {
            g2.drawString(this.ticket.getTicketFoot().getSummary(), xIdx, yIdx += line + 1.0f);
        }
        if (!StringUtils.isBlank((CharSequence)this.ticket.getTicketFoot().getServiceTel())) {
            g2.drawString("\u5ba2\u670d\u7535\u8bdd:" + this.ticket.getTicketFoot().getServiceTel(), xIdx, yIdx += line);
        }
        if (!StringUtils.isBlank((CharSequence)this.ticket.getTicketFoot().getUrl1())) {
            g2.drawString("\u7f51\u5740:" + this.ticket.getTicketFoot().getUrl1(), xIdx, yIdx += line);
        }
        if (!StringUtils.isBlank((CharSequence)this.ticket.getTicketFoot().getUrl2())) {
            g2.drawString("\u7f51\u5740:" + this.ticket.getTicketFoot().getUrl2(), xIdx, yIdx += line);
        }
        if (!StringUtils.isBlank((CharSequence)this.ticket.getTicketFoot().getUrl3())) {
            g2.drawString("\u7f51\u5740:" + this.ticket.getTicketFoot().getUrl3(), xIdx, yIdx += line);
        }
        g2.drawString(this.ticket.getTicketFoot().getWelcome(), xIdx, yIdx += line);
        switch (pageIndex) {
            case 0: {
                return 0;
            }
        }
        return 1;
    }

    public List<String> detachString(String str, int max) {
        if (StringUtils.isBlank((CharSequence)str)) {
            return Collections.EMPTY_LIST;
        }
        int len = str.length();
        ArrayList<String> list = new ArrayList<String>();
        if (len <= max) {
            list.add(str);
            return list;
        }
        while (len > max) {
            String tmp = str.substring(0, max);
            list.add(tmp);
            str = str.substring(tmp.length(), len);
            len = str.length();
        }
        list.add(str);
        return list;
    }

    public String replaceStar(String str, int max, int beg, int end) {
        int istar;
        if (StringUtils.isBlank((CharSequence)str)) {
            return str;
        }
        int len = str.length();
        if (beg == 0 || beg < 0) {
            beg = 10;
        }
        if (end == 0 || end < 0) {
            end = 8;
        }
        if (len <= max) {
            return str;
        }
        int ibeg = beg;
        int iend = end;
        while ((istar = max - --ibeg - --iend) < 4) {
        }
        String asterisk = "";
        for (int i = 0; i < istar; ++i) {
            asterisk = asterisk + "*";
        }
        return str.substring(0, ibeg) + asterisk + str.substring(len - iend, len);
    }

    public void setTicket(Ticket ticket) {
        this.ticket = ticket;
    }
}

