/*
 * Decompiled with CFR 0.152.
 */
package com.kmall.common.utils.excel;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.zip.ZipInputStream;
import org.apache.commons.lang3.StringUtils;

public class FileUtil {
    protected static byte[] buf = new byte[1024];

    public static boolean mkdirs(String path) {
        try {
            File f = new File(path);
            if (!f.exists()) {
                f.mkdirs();
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static String readFileAsString(String fileName) throws Exception {
        String content = new String(FileUtil.readFileBinary(fileName));
        return content;
    }

    public static String readFileAsString(String fileName, String encoding) throws Exception {
        String content = new String(FileUtil.readFileBinary(fileName), encoding);
        return content;
    }

    public static String readFileAsString(InputStream in) throws IOException {
        String content = new String(FileUtil.readFileBinary(in));
        return content;
    }

    public static byte[] readFileBinary(String fileName) throws Exception {
        FileInputStream fin = new FileInputStream(fileName);
        return FileUtil.readFileBinary(fin);
    }

    public static byte[] readFileBinary(InputStream streamIn) throws IOException {
        int len;
        BufferedInputStream in = new BufferedInputStream(streamIn);
        ByteArrayOutputStream out = new ByteArrayOutputStream(10240);
        while ((len = in.read(buf)) >= 0) {
            out.write(buf, 0, len);
        }
        in.close();
        return out.toByteArray();
    }

    public static boolean writeFileString(String fileName, String content) throws IOException {
        FileWriter fout = new FileWriter(fileName);
        fout.write(content);
        fout.close();
        return true;
    }

    public static boolean writeFileString(String fileName, String content, String encoding) throws IOException {
        OutputStreamWriter fout = new OutputStreamWriter((OutputStream)new FileOutputStream(fileName), encoding);
        fout.write(content);
        fout.close();
        return true;
    }

    public static boolean writeFileBinary(String fileName, byte[] content) throws IOException {
        if (content == null || StringUtils.isEmpty((CharSequence)fileName)) {
            return false;
        }
        FileOutputStream fout = null;
        try {
            fout = new FileOutputStream(fileName);
            fout.write(content);
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            if (fout != null) {
                try {
                    fout.close();
                }
                catch (IOException iOException) {}
            }
        }
        return true;
    }

    public static boolean isValidFileName(String fileName) {
        boolean isValid2 = true;
        String errChar = "\\/:*?\"<>|";
        if (fileName == null || fileName.length() == 0) {
            isValid2 = false;
        } else {
            for (int i = 0; i < errChar.length(); ++i) {
                if (fileName.indexOf(errChar.charAt(i)) == -1) continue;
                isValid2 = false;
                break;
            }
        }
        return isValid2;
    }

    public static String replaceInvalidFileChars(String fileName) {
        StringBuffer out = new StringBuffer();
        block3: for (int i = 0; i < fileName.length(); ++i) {
            char ch = fileName.charAt(i);
            switch (ch) {
                case '\"': 
                case '*': 
                case '/': 
                case ':': 
                case '<': 
                case '>': 
                case '?': 
                case '\\': 
                case '|': {
                    out.append('_');
                    continue block3;
                }
                default: {
                    out.append(ch);
                }
            }
        }
        return out.toString();
    }

    public static String filePathToURL(String fileName) {
        String fileUrl = new File(fileName).toURI().toString();
        return fileUrl;
    }

    public static boolean appendFileString(String fileName, String content) throws IOException {
        OutputStreamWriter fout = new OutputStreamWriter((OutputStream)new FileOutputStream(fileName, true), "UTF-8");
        fout.write(content);
        fout.close();
        return true;
    }

    public static String getFileName(String filePathAndName) {
        int b;
        int a = filePathAndName.lastIndexOf("\\");
        String fileName = filePathAndName.substring((a > (b = filePathAndName.lastIndexOf("/")) ? a : b) + 1, filePathAndName.length());
        return fileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean copy(String fileFrom, String fileTo) {
        FileInputStream in = null;
        FileOutputStream out = null;
        try {
            int count;
            in = new FileInputStream(fileFrom);
            out = new FileOutputStream(fileTo);
            byte[] bt = new byte[1024];
            while ((count = in.read(bt)) > 0) {
                out.write(bt, 0, count);
            }
            boolean bl = true;
            return bl;
        }
        catch (IOException ex) {
            ex.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static byte[] readInputStream(InputStream inStream) throws Exception {
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        int len = 0;
        while ((len = inStream.read(buffer)) != -1) {
            outStream.write(buffer, 0, len);
        }
        inStream.close();
        return outStream.toByteArray();
    }

    public static byte[] readZipInputStream(ZipInputStream inStream) throws Exception {
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        int len = 0;
        while ((len = inStream.read(buffer)) != -1) {
            outStream.write(buffer, 0, len);
        }
        inStream.closeEntry();
        return outStream.toByteArray();
    }

    public static boolean delAllFile(String path) {
        boolean flag = false;
        File file = new File(path);
        if (!file.exists()) {
            return flag;
        }
        if (!file.isDirectory()) {
            return flag;
        }
        String[] tempList = file.list();
        File temp = null;
        for (int i = 0; i < tempList.length; ++i) {
            temp = path.endsWith(File.separator) ? new File(path + tempList[i]) : new File(path + File.separator + tempList[i]);
            if (temp.isFile()) {
                temp.delete();
            }
            if (!temp.isDirectory()) continue;
            FileUtil.delAllFile(path + "/" + tempList[i]);
            FileUtil.delFolder(path + "/" + tempList[i]);
            flag = true;
        }
        return flag;
    }

    public static void delFolder(String folderPath) {
        try {
            FileUtil.delAllFile(folderPath);
            String filePath = folderPath;
            filePath = filePath.toString();
            File myFilePath = new File(filePath);
            myFilePath.delete();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

