/*
 * Decompiled with CFR 0.152.
 */
package com.kmall.common.utils.excel;

import com.kmall.common.utils.excel.FileUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.jxls.reader.ReaderBuilder;
import org.jxls.reader.XLSReader;
import org.springframework.stereotype.Component;
import org.xml.sax.SAXException;

@Component
public class ExcelUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void exportExcel(String fileName, String[] titles, List<Map<Integer, String>> lists, HttpServletResponse response, HttpServletRequest request) throws IOException {
        XSSFWorkbook xls = new XSSFWorkbook();
        XSSFSheet sheet = xls.createSheet("Sheet1");
        XSSFRow row = sheet.createRow(0);
        for (int i = 0; i < titles.length; ++i) {
            sheet.setColumnWidth(i, 5000);
            sheet.setColumnWidth(0, 1300);
            row.createCell(i).setCellValue(titles[i]);
        }
        int rowNum = 1;
        for (Map<Integer, String> map : lists) {
            XSSFRow rowTmp = sheet.createRow(rowNum);
            int cols = map.size();
            for (int i = 0; i < cols; ++i) {
                rowTmp.createCell(i).setCellValue(map.get(i));
            }
            ++rowNum;
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        xls.write((OutputStream)os);
        byte[] content = os.toByteArray();
        ByteArrayInputStream is = new ByteArrayInputStream(content);
        String userAgent = request.getHeader("USER-AGENT");
        String finalFileName = null;
        finalFileName = userAgent.contains("MSIE") || userAgent.contains("Trident") ? URLEncoder.encode(fileName + ".xlsx", "UTF-8") : (StringUtils.contains((String)userAgent, (String)"Mozilla") ? new String((fileName + ".xlsx").getBytes("UTF-8"), "ISO-8859-1") : URLEncoder.encode(fileName + ".xlsx", "UTF-8"));
        response.reset();
        response.setContentType("application/vnd.ms-excel;charset=utf-8");
        response.setHeader("Content-Disposition", "attachment;filename=" + finalFileName);
        ServletOutputStream out = response.getOutputStream();
        BufferedInputStream bis = null;
        FilterOutputStream bos = null;
        try {
            int bytesRead;
            bis = new BufferedInputStream(is);
            bos = new BufferedOutputStream((OutputStream)out);
            byte[] buff = new byte[2048];
            while (-1 != (bytesRead = bis.read(buff, 0, buff.length))) {
                ((BufferedOutputStream)bos).write(buff, 0, bytesRead);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (bis != null) {
                bis.close();
            }
            if (bos != null) {
                bos.close();
            }
        }
        os.close();
    }

    public static void exportFile(String fileName, HttpServletResponse response, InputStream inStream) throws Exception {
        byte[] data = FileUtil.readInputStream(inStream);
        ServletOutputStream os = null;
        try {
            os = response.getOutputStream();
            response.setContentType("application/octet-stream ");
            response.setHeader("Connection", "close");
            response.setHeader("Accept-Ranges", "bytes");
            response.setHeader("Content-Disposition", "attachment;filename=" + new String(fileName.getBytes("GB2312"), "ISO8859-1"));
            response.setCharacterEncoding("UTF-8");
            os.write(data);
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            if (inStream != null) {
                inStream.close();
            }
        }
        os.close();
    }

    public void readExcel(String name, Map<String, Object> beans, InputStream in) throws InvalidFormatException, SAXException, IOException {
        InputStream inputXML = null;
        InputStream inputXLS = null;
        try {
            inputXML = new BufferedInputStream(this.getClass().getResourceAsStream(name));
            XLSReader mainReader = ReaderBuilder.buildFromXML((InputStream)inputXML);
            inputXLS = new BufferedInputStream(in);
            mainReader.read(inputXLS, beans);
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (inputXML != null) {
                inputXML.close();
            }
            if (inputXLS != null) {
                inputXLS.close();
            }
        }
    }

    public void readZipExcel(String name, Map<String, Object> beans, ZipInputStream in) throws InvalidFormatException, SAXException, IOException {
        BufferedInputStream inputXML = null;
        BufferedInputStream inputXLS = null;
        inputXML = new BufferedInputStream(this.getClass().getResourceAsStream(name));
        XLSReader mainReader = ReaderBuilder.buildFromXML((InputStream)inputXML);
        inputXLS = new BufferedInputStream(in);
        mainReader.read((InputStream)in, beans);
    }

    public static InputStream getInputStream(String path) throws IOException {
        InputStream inputStream = null;
        HttpURLConnection httpURLConnection = null;
        try {
            URL url = new URL(path);
            if (url != null) {
                httpURLConnection = (HttpURLConnection)url.openConnection();
                httpURLConnection.setConnectTimeout(3000);
                httpURLConnection.setRequestMethod("GET");
                int responseCode = httpURLConnection.getResponseCode();
                if (responseCode == 200) {
                    inputStream = httpURLConnection.getInputStream();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        return inputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void exportFormatExcel(String fileName, String[] titles, String[] width, List<Map<Integer, String>> lists, HttpServletResponse response, HttpServletRequest request) throws IOException {
        XSSFWorkbook xls = new XSSFWorkbook();
        XSSFSheet sheet = xls.createSheet("Sheet1");
        XSSFRow row = sheet.createRow(0);
        row.setHeight((short)600);
        for (int i = 0; i < titles.length; ++i) {
            row.createCell(i).setCellValue(titles[i]);
            sheet.setColumnWidth(i, Integer.valueOf(width[i]).intValue());
        }
        if (lists.size() > 1) {
            sheet.addMergedRegion(new CellRangeAddress(1, lists.size(), 8, 8));
            sheet.addMergedRegion(new CellRangeAddress(1, lists.size(), 9, 9));
            sheet.addMergedRegion(new CellRangeAddress(1, lists.size(), 10, 10));
        }
        int rowNum = 1;
        for (Map<Integer, String> map : lists) {
            XSSFRow rowTmp = sheet.createRow(rowNum);
            int cols = map.size();
            for (int i = 0; i < cols; ++i) {
                rowTmp.createCell(i).setCellValue(map.get(i));
            }
            ++rowNum;
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        xls.write((OutputStream)os);
        byte[] content = os.toByteArray();
        ByteArrayInputStream is = new ByteArrayInputStream(content);
        String userAgent = request.getHeader("USER-AGENT");
        String finalFileName = null;
        finalFileName = userAgent.contains("MSIE") || userAgent.contains("Trident") ? URLEncoder.encode(fileName + ".xlsx", "UTF-8") : (StringUtils.contains((String)userAgent, (String)"Mozilla") ? new String((fileName + ".xlsx").getBytes("UTF-8"), "ISO-8859-1") : URLEncoder.encode(fileName + ".xlsx", "UTF-8"));
        response.reset();
        response.setContentType("application/vnd.ms-excel;charset=utf-8");
        response.setHeader("Content-Disposition", "attachment;filename=" + finalFileName);
        ServletOutputStream out = response.getOutputStream();
        BufferedInputStream bis = null;
        FilterOutputStream bos = null;
        try {
            int bytesRead;
            bis = new BufferedInputStream(is);
            bos = new BufferedOutputStream((OutputStream)out);
            byte[] buff = new byte[2048];
            while (-1 != (bytesRead = bis.read(buff, 0, buff.length))) {
                ((BufferedOutputStream)bos).write(buff, 0, bytesRead);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (bis != null) {
                bis.close();
            }
            if (bos != null) {
                bos.close();
            }
        }
        os.close();
    }
}

