/*
 * Decompiled with CFR 0.152.
 */
package com.kmall.common.utils.excel;

import com.kmall.common.utils.RRException;
import com.kmall.common.utils.excel.Excel2003Reader;
import com.kmall.common.utils.excel.Excel2007Reader;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.springframework.web.multipart.MultipartFile;

public class ExcelImport {
    public static final String EXCEL03_EXTENSION = ".xls";
    public static final String EXCEL07_EXTENSION = ".xlsx";

    private ExcelImport() {
    }

    public static List<String[]> getExcelData07(MultipartFile excelFile) {
        List<String[]> resultList = null;
        if (null == excelFile || excelFile.isEmpty()) {
            throw new RRException("\u6587\u4ef6\u5185\u5bb9\u4e3a\u7a7a\uff01");
        }
        Excel2007Reader excel07 = new Excel2007Reader();
        try {
            excel07.process(excelFile.getInputStream(), false);
        }
        catch (Exception e) {
            throw new RRException("excel\u89e3\u6790\u5931\u8d25\uff01");
        }
        resultList = excel07.getSheetData(0);
        return resultList;
    }

    public static List<String[]> getExcelData03(MultipartFile excelFile) {
        List<String[]> resultList = null;
        if (null == excelFile || excelFile.isEmpty()) {
            throw new RRException("\u6587\u4ef6\u5185\u5bb9\u4e3a\u7a7a\uff01");
        }
        Excel2003Reader excel03 = new Excel2003Reader();
        try {
            excel03.process(excelFile.getInputStream());
        }
        catch (IOException e) {
            throw new RRException("excel\u89e3\u6790\u5931\u8d25\uff01");
        }
        resultList = excel03.getSheetData(0);
        return resultList;
    }

    public static List<String[]> getExcelData(MultipartFile excelFile) throws RRException {
        List<String[]> resultList = null;
        if (!excelFile.isEmpty()) {
            String excelFileName = excelFile.getOriginalFilename();
            if (excelFileName.toLowerCase().endsWith(EXCEL03_EXTENSION)) {
                Excel2003Reader excel03 = new Excel2003Reader();
                try {
                    excel03.process(excelFile.getInputStream());
                }
                catch (IOException e) {
                    throw new RRException("excel\u89e3\u6790\u5931\u8d25\uff01");
                }
                resultList = excel03.getSheetData(0);
            } else if (excelFileName.toLowerCase().endsWith(EXCEL07_EXTENSION)) {
                Excel2007Reader excel07 = new Excel2007Reader();
                try {
                    excel07.process(excelFile.getInputStream(), false);
                }
                catch (Exception e) {
                    throw new RRException("excel\u89e3\u6790\u5931\u8d25\uff01");
                }
                resultList = excel07.getSheetData(0);
            }
        }
        return resultList;
    }

    public static Map<Integer, List<String[]>> getExcelDataAll(MultipartFile excelFile) throws RRException {
        Map<Integer, List<String[]>> result = null;
        if (!excelFile.isEmpty()) {
            String excelFileName = excelFile.getOriginalFilename();
            if (excelFileName.toLowerCase().endsWith(EXCEL03_EXTENSION)) {
                Excel2003Reader excel03 = new Excel2003Reader();
                try {
                    excel03.process(excelFile.getInputStream());
                }
                catch (IOException e) {
                    throw new RRException("excel\u89e3\u6790\u5931\u8d25\uff01");
                }
                result = excel03.getSheetData();
            } else if (excelFileName.toLowerCase().endsWith(EXCEL07_EXTENSION)) {
                Excel2007Reader excel07 = new Excel2007Reader();
                try {
                    excel07.process(excelFile.getInputStream(), true);
                }
                catch (Exception e) {
                    throw new RRException("excel\u89e3\u6790\u5931\u8d25\uff01");
                }
                result = excel07.getSheetData();
            }
        }
        return result;
    }
}

