/*
 * Decompiled with CFR 0.152.
 */
package com.kmall.common.utils.excel;

import com.kmall.common.utils.RRException;
import com.kmall.common.utils.StringUtils;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class ExcelExport {
    public static final String EXCEL03_EXTENSION = ".xls";
    public static final String EXCEL07_EXTENSION = ".xls";
    private Workbook workBook;
    private String exportFileName;
    private Log logger = LogFactory.getLog(ExcelExport.class);

    public ExcelExport() {
        this("workbook.xlsx");
    }

    public ExcelExport(String exportFileName) {
        String fileName;
        if (StringUtils.isNullOrEmpty(exportFileName)) {
            exportFileName = "workbook.xlsx";
        }
        if ((fileName = exportFileName.toLowerCase()).endsWith(".xls")) {
            this.workBook = new HSSFWorkbook();
        } else if (exportFileName.endsWith(".xls")) {
            this.workBook = new XSSFWorkbook();
        } else {
            this.workBook = new XSSFWorkbook();
            fileName = fileName + ".xlsx";
        }
        this.exportFileName = fileName;
    }

    public void export(HttpServletResponse response) {
        response.reset();
        response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet;charset=UTF-8");
        String fileName = null;
        try {
            HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
            String userAgent = request.getHeader("User-Agent");
            fileName = userAgent.contains("MSIE") || userAgent.contains("Trident") ? URLEncoder.encode(this.exportFileName, "UTF-8") : new String(this.exportFileName.getBytes("UTF-8"), "ISO-8859-1");
        }
        catch (UnsupportedEncodingException e) {
            fileName = "export.xls";
        }
        response.setHeader("Content-Disposition", "attachment;filename=" + fileName);
        try {
            ServletOutputStream output = response.getOutputStream();
            this.workBook.write((OutputStream)output);
            output.flush();
            output.close();
        }
        catch (IOException e) {
            this.logger.error((Object)"\u5bfc\u51fa\u6587\u4ef6\u51fa\u9519\u4e86", (Throwable)e);
            throw new RRException("\u6587\u4ef6\u5bfc\u51fa\u9519\u8bef");
        }
    }

    public static void main(String[] args) {
        ExcelExport ee1 = new ExcelExport();
        ArrayList<Object[]> list1 = new ArrayList<Object[]>();
        ArrayList<Object> obj = new ArrayList<Object>();
        obj.add("370681198002042214");
        obj.add(new Date());
        obj.add(new Timestamp(System.currentTimeMillis()));
        obj.add(1);
        obj.add(11111111111111L);
        obj.add(Float.valueOf(123456.125f));
        obj.add(1.2345678912345678E8);
        obj.add(new BigDecimal("123456789123456789.1234"));
        obj.add(true);
        list1.add(obj.toArray());
        String[] header = new String[]{"\u8eab\u4efd\u8bc1\u53f7", "\u65e5\u671f", "\u65f6\u95f4", "\u6574\u578b", "\u957f\u6574", "\u6d6e\u70b9", "\u53cc\u7cbe\u5ea6", "\u5927\u6570", "\u5e03\u5c14"};
        ee1.addSheetByArray("\u6d4b\u8bd51", list1, header);
        try {
            FileOutputStream fis = new FileOutputStream("D:\\test1.xlsx");
            ee1.getWorkbook().write((OutputStream)fis);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void addSheetByArray(String sheetName, List<Object[]> list, String[] colCaption) {
        Sheet sheet = StringUtils.isNullOrEmpty(sheetName) ? this.workBook.createSheet() : this.workBook.createSheet(sheetName);
        this.createCaptionRow(colCaption, sheet);
        int colNum = 0;
        int startRow = 1;
        for (Object[] obj : list) {
            Row row = sheet.createRow(startRow++);
            int cols = this.createRowData(row, Arrays.asList(obj));
            row.setHeight((short)400);
            colNum = colNum > cols ? colNum : cols;
        }
        this.adjustCellWidth(colNum, startRow, sheet);
    }

    public void addSheetByMap(String sheetName, List<Map<String, Object>> list, String[] colCaption) {
        Sheet sheet = StringUtils.isNullOrEmpty(sheetName) ? this.workBook.createSheet() : this.workBook.createSheet(sheetName);
        this.createCaptionRow(colCaption, sheet);
        int colNum = 0;
        int startRow = 1;
        for (Map<String, Object> map : list) {
            Row row = sheet.createRow(startRow++);
            int cols = this.createRowData(row, map.values());
            row.setHeight((short)400);
            colNum = colNum > cols ? colNum : cols;
        }
        this.adjustCellWidth(colNum, startRow, sheet);
    }

    private boolean isInIgnors(String name, String[] ignores) {
        for (String ignore : ignores) {
            if (!name.equals(ignore)) continue;
            return true;
        }
        return false;
    }

    private int createRowData(Row row, Collection<Object> coll) {
        int cellNum = 0;
        for (Object obj : coll) {
            if (obj == null) {
                obj = "";
            }
            String strValue = obj.toString();
            Cell cell = row.createCell(cellNum);
            if (!strValue.startsWith("FORMULA:")) {
                this.setCellValue(cell, obj);
            }
            ++cellNum;
        }
        return cellNum;
    }

    private void setCellValue(Cell cell, Object obj) {
        CreationHelper createHelper = this.workBook.getCreationHelper();
        String strValue = obj.toString();
        if (obj instanceof Timestamp) {
            Timestamp dt = (Timestamp)obj;
            CellStyle cellStyle = this.workBook.createCellStyle();
            cellStyle.setDataFormat(createHelper.createDataFormat().getFormat("yyyy-MM-dd HH:mm:ss"));
            cell.setCellValue((Date)dt);
            cell.setCellStyle(cellStyle);
        } else if (obj instanceof Date) {
            CellStyle cellStyle = this.workBook.createCellStyle();
            cellStyle.setDataFormat(createHelper.createDataFormat().getFormat("yyyy-MM-dd"));
            cell.setCellValue((Date)obj);
            cell.setCellStyle(cellStyle);
        } else if (obj instanceof Integer) {
            cell.setCellType(CellType.NUMERIC);
            DecimalFormat df = new DecimalFormat("0");
            String value = df.format(obj);
            cell.setCellValue(value);
        } else if (obj instanceof Long) {
            cell.setCellType(CellType.NUMERIC);
            DecimalFormat df = new DecimalFormat("0");
            String value = df.format(obj);
            cell.setCellValue(value);
        } else if (obj instanceof Float) {
            cell.setCellType(CellType.NUMERIC);
            DecimalFormat df = new DecimalFormat("0.0000");
            String value = df.format(obj);
            cell.setCellValue(value);
        } else if (obj instanceof Double) {
            cell.setCellType(CellType.NUMERIC);
            DecimalFormat df = new DecimalFormat("0.0000");
            String value = df.format(obj);
            cell.setCellValue(value);
        } else if (obj instanceof BigDecimal) {
            cell.setCellType(CellType.STRING);
            cell.setCellValue(strValue);
        } else if (obj instanceof String) {
            cell.setCellType(CellType.STRING);
            cell.setCellValue(strValue);
        } else {
            cell.setCellType(CellType.STRING);
            cell.setCellValue(strValue);
        }
    }

    private void createCaptionRow(String[] colCaption, Sheet sheet) {
        Row row = sheet.createRow(0);
        row.setHeight((short)400);
        if (colCaption == null) {
            return;
        }
        for (int i = 0; i < colCaption.length; ++i) {
            Cell cell = row.createCell(i);
            cell.setCellStyle(this.getStyle("title"));
            cell.setCellType(CellType.STRING);
            cell.setCellValue(colCaption[i]);
        }
    }

    private void adjustCellWidth(int cols, int rows, Sheet sheet) {
        int[] cellWidth = new int[cols];
        for (int col = 0; col < cols; ++col) {
            for (int row = 0; row < rows; ++row) {
                Cell cell = sheet.getRow(row).getCell(col);
                String value = this.getCellValue(cell);
                int length = value.getBytes().length;
                if (length <= cellWidth[col]) continue;
                cellWidth[col] = length;
            }
        }
        for (int j = 0; j < cellWidth.length; ++j) {
            if (cellWidth[j] > 254) {
                cellWidth[j] = 254;
            }
            sheet.setColumnWidth(j, cellWidth[j] * 12 > 255 ? 6528 : cellWidth[j] * 12 * 256 / 10);
        }
    }

    private String getCellValue(Cell cell) {
        String value = "";
        try {
            switch (cell.getCellTypeEnum()) {
                case NUMERIC: {
                    value = cell.getNumericCellValue() + "1111";
                    break;
                }
                case STRING: {
                    value = cell.getStringCellValue();
                    break;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return value;
    }

    private CellStyle getStyle(String type) {
        CellStyle cs = this.workBook.createCellStyle();
        if ("title".equals(type)) {
            Font font = this.workBook.createFont();
            font.setBold(true);
            cs.setAlignment(HorizontalAlignment.CENTER);
            cs.setFillBackgroundColor((short)40);
            cs.setFont(font);
        }
        return cs;
    }

    public Workbook getWorkbook() {
        return this.workBook;
    }

    public void setWorkbook(Workbook workBook) {
        this.workBook = workBook;
    }

    public String getExportFileName() {
        return this.exportFileName;
    }

    public void setExportFileName(String exportFileName) {
        this.exportFileName = exportFileName;
    }
}

