/*
 * Decompiled with CFR 0.152.
 */
package com.kmall.common.utils.excel;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URLDecoder;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFDataFormat;
import org.apache.poi.hssf.usermodel.HSSFDateUtil;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFFormulaEvaluator;
import org.apache.poi.hssf.usermodel.HSSFPalette;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.FormulaEvaluator;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFFormulaEvaluator;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class Excel2Html {
    private static FormulaEvaluator eval = null;
    static String[] bordesr = new String[]{"border-top:", "border-right:", "border-bottom:", "border-left:"};
    static String[] borderStyles = new String[]{"solid ", "solid ", "solid ", "solid ", "solid ", "solid ", "solid ", "solid ", "solid ", "solid", "solid", "solid", "solid", "solid"};

    public static void main(String[] args) throws UnsupportedEncodingException {
        String path = Excel2Html.class.getResource(".").getPath();
        String realPath = URLDecoder.decode(path, "utf-8");
        String str = Excel2Html.excelToHtml(realPath + "\\acctExport.xlsx");
        System.out.println(str);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String excelToHtml(String realPath) {
        String excelFile = realPath;
        InputStream is = null;
        String content = null;
        File sourcefile = null;
        try {
            sourcefile = new File(excelFile);
            is = new FileInputStream(sourcefile);
            Workbook wb = WorkbookFactory.create((InputStream)is);
            if (wb instanceof XSSFWorkbook) {
                XSSFWorkbook xWb = (XSSFWorkbook)wb;
                eval = new XSSFFormulaEvaluator((XSSFWorkbook)wb);
                content = Excel2Html.getExcelInfo((Workbook)xWb, true);
                return content;
            }
            if (!(wb instanceof HSSFWorkbook)) return content;
            HSSFWorkbook hWb = (HSSFWorkbook)wb;
            eval = new HSSFFormulaEvaluator((HSSFWorkbook)wb);
            content = Excel2Html.getExcelInfo((Workbook)hWb, true);
            return content;
        }
        catch (Exception e) {
            e.printStackTrace();
            return content;
        }
        finally {
            try {
                is.close();
                if (!sourcefile.exists()) {
                    // empty if block
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static String getExcelInfo(Workbook wb, boolean isWithStyle) {
        StringBuffer sb = new StringBuffer();
        Sheet sheet = wb.getSheetAt(0);
        int lastRowNum = sheet.getLastRowNum();
        Map<String, String>[] map = Excel2Html.getRowSpanColSpanMap(sheet);
        sb.append("<table style='border-collapse:collapse;' id='gv' width='100%'>");
        Row row = null;
        Cell cell = null;
        for (int rowNum = sheet.getFirstRowNum(); rowNum <= lastRowNum; ++rowNum) {
            row = sheet.getRow(rowNum);
            if (row == null) {
                sb.append("<tr><td >  </td></tr>");
                continue;
            }
            sb.append("<tr>");
            int lastColNum = row.getLastCellNum();
            for (int colNum = 0; colNum < lastColNum; ++colNum) {
                cell = row.getCell(colNum);
                if (cell == null) {
                    sb.append("<td> </td>");
                    continue;
                }
                String stringValue = Excel2Html.getCellValueFormula(cell, eval);
                if (map[0].containsKey(rowNum + "," + colNum)) {
                    String pointString = map[0].get(rowNum + "," + colNum);
                    map[0].remove(rowNum + "," + colNum);
                    int bottomeRow = Integer.valueOf(pointString.split(",")[0]);
                    int bottomeCol = Integer.valueOf(pointString.split(",")[1]);
                    int rowSpan = bottomeRow - rowNum + 1;
                    int colSpan = bottomeCol - colNum + 1;
                    sb.append("<td rowspan= '" + rowSpan + "' colspan= '" + colSpan + "' ");
                } else {
                    if (map[1].containsKey(rowNum + "," + colNum)) {
                        map[1].remove(rowNum + "," + colNum);
                        continue;
                    }
                    sb.append("<td ");
                }
                if (isWithStyle) {
                    Excel2Html.dealExcelStyle(wb, sheet, cell, sb);
                }
                sb.append(">");
                if (stringValue == null || "".equals(stringValue.trim())) {
                    sb.append("   ");
                } else {
                    sb.append(stringValue.replace(String.valueOf('\u00a0'), " "));
                }
                sb.append("</td>");
            }
            sb.append("</tr>");
        }
        sb.append("</table>");
        return sb.toString();
    }

    private static Map<String, String>[] getRowSpanColSpanMap(Sheet sheet) {
        HashMap<String, String> map0 = new HashMap<String, String>();
        HashMap<String, String> map1 = new HashMap<String, String>();
        int mergedNum = sheet.getNumMergedRegions();
        CellRangeAddress range = null;
        for (int i = 0; i < mergedNum; ++i) {
            range = sheet.getMergedRegion(i);
            int topRow = range.getFirstRow();
            int topCol = range.getFirstColumn();
            int bottomRow = range.getLastRow();
            int bottomCol = range.getLastColumn();
            map0.put(topRow + "," + topCol, bottomRow + "," + bottomCol);
            for (int tempRow = topRow; tempRow <= bottomRow; ++tempRow) {
                for (int tempCol = topCol; tempCol <= bottomCol; ++tempCol) {
                    map1.put(tempRow + "," + tempCol, "");
                }
            }
            map1.remove(topRow + "," + topCol);
        }
        Map[] map = new Map[]{map0, map1};
        return map;
    }

    private static String getCellValue(Cell cell) {
        String result = new String();
        switch (cell.getCellType()) {
            case 0: {
                if (HSSFDateUtil.isCellDateFormatted((Cell)cell)) {
                    SimpleDateFormat sdf = null;
                    sdf = cell.getCellStyle().getDataFormat() == HSSFDataFormat.getBuiltinFormat((String)"h:mm") ? new SimpleDateFormat("HH:mm") : new SimpleDateFormat("yyyy-MM-dd");
                    Date date = cell.getDateCellValue();
                    result = sdf.format(date);
                    break;
                }
                if (cell.getCellStyle().getDataFormat() == 58) {
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                    double value = cell.getNumericCellValue();
                    Date date = DateUtil.getJavaDate((double)value);
                    result = sdf.format(date);
                    break;
                }
                if (cell.getCellStyle().getDataFormat() == 10) {
                    cell.setCellType(1);
                    String value = cell.getStringCellValue();
                    DecimalFormat format = new DecimalFormat("#0.00%");
                    result = format.format(Double.parseDouble(value));
                    break;
                }
                if (cell.getCellStyle().getDataFormatString().equals("0.0000%")) {
                    cell.setCellType(1);
                    String value = cell.getStringCellValue();
                    DecimalFormat format = new DecimalFormat("#0.0000%");
                    result = format.format(Double.parseDouble(value));
                    break;
                }
                double value = cell.getNumericCellValue();
                CellStyle style = cell.getCellStyle();
                DecimalFormat format = new DecimalFormat(",##0.00########");
                String temp = style.getDataFormatString();
                if (temp.equals("General")) {
                    format.applyPattern("#");
                }
                result = format.format(value);
                break;
            }
            case 1: {
                result = cell.getRichStringCellValue().toString();
                break;
            }
            case 3: {
                result = "";
                break;
            }
            default: {
                result = "";
            }
        }
        return result;
    }

    public static String getCellValueFormula(Cell cell, FormulaEvaluator formulaEvaluator) {
        if (cell == null || formulaEvaluator == null) {
            return null;
        }
        if (cell.getCellType() == 2) {
            DecimalFormat format = new DecimalFormat(",##0.00########");
            double calcResult = formulaEvaluator.evaluate(cell).getNumberValue();
            return format.format(new BigDecimal(calcResult).setScale(2, 4));
        }
        return Excel2Html.getCellValue(cell);
    }

    private static void dealExcelStyle(Workbook wb, Sheet sheet, Cell cell, StringBuffer sb) {
        CellStyle cellStyle = cell.getCellStyle();
        if (cellStyle != null) {
            short alignment = cellStyle.getAlignment();
            sb.append("align='" + Excel2Html.convertAlignToHtml(alignment) + "' ");
            short verticalAlignment = cellStyle.getVerticalAlignment();
            sb.append("valign='" + Excel2Html.convertVerticalAlignToHtml(verticalAlignment) + "' ");
            if (wb instanceof XSSFWorkbook) {
                XSSFColor bgColor;
                XSSFFont xf = ((XSSFCellStyle)cellStyle).getFont();
                short boldWeight = xf.getBoldweight();
                sb.append("style='");
                sb.append("font-weight:" + boldWeight + ";");
                sb.append("font-size: " + xf.getFontHeight() / 2 + "%;");
                int columnWidth = sheet.getColumnWidth(cell.getColumnIndex());
                sb.append("width:" + columnWidth + "px;");
                XSSFColor xc = xf.getXSSFColor();
                if (xc != null && !"".equals(xc)) {
                    sb.append("color:#" + xc.getARGBHex().substring(2) + ";");
                }
                if ((bgColor = (XSSFColor)cellStyle.getFillForegroundColorColor()) != null && !"".equals(bgColor)) {
                    sb.append("background-color:#" + bgColor.getARGBHex().substring(2) + ";");
                }
                sb.append(Excel2Html.getBorderStyle(0, cellStyle.getBorderTop(), ((XSSFCellStyle)cellStyle).getTopBorderXSSFColor()));
                sb.append(Excel2Html.getBorderStyle(1, cellStyle.getBorderRight(), ((XSSFCellStyle)cellStyle).getRightBorderXSSFColor()));
                sb.append(Excel2Html.getBorderStyle(2, cellStyle.getBorderBottom(), ((XSSFCellStyle)cellStyle).getBottomBorderXSSFColor()));
                sb.append(Excel2Html.getBorderStyle(3, cellStyle.getBorderLeft(), ((XSSFCellStyle)cellStyle).getLeftBorderXSSFColor()));
            } else if (wb instanceof HSSFWorkbook) {
                HSSFFont hf = ((HSSFCellStyle)cellStyle).getFont(wb);
                short boldWeight = hf.getBoldweight();
                short fontColor = hf.getColor();
                sb.append("style='");
                HSSFPalette palette = ((HSSFWorkbook)wb).getCustomPalette();
                HSSFColor hc = palette.getColor(fontColor);
                sb.append("font-weight:" + boldWeight + ";");
                sb.append("font-size: " + hf.getFontHeight() / 2 + "%;");
                String fontColorStr = Excel2Html.convertToStardColor(hc);
                if (fontColorStr != null && !"".equals(fontColorStr.trim())) {
                    sb.append("color:" + fontColorStr + ";");
                }
                int columnWidth = sheet.getColumnWidth(cell.getColumnIndex());
                sb.append("width:" + columnWidth + "px;");
                short bgColor = cellStyle.getFillForegroundColor();
                hc = palette.getColor(bgColor);
                String bgColorStr = Excel2Html.convertToStardColor(hc);
                if (bgColorStr != null && !"".equals(bgColorStr.trim())) {
                    sb.append("background-color:" + bgColorStr + ";");
                }
                sb.append(Excel2Html.getBorderStyle(palette, 0, cellStyle.getBorderTop(), cellStyle.getTopBorderColor()));
                sb.append(Excel2Html.getBorderStyle(palette, 1, cellStyle.getBorderRight(), cellStyle.getRightBorderColor()));
                sb.append(Excel2Html.getBorderStyle(palette, 3, cellStyle.getBorderLeft(), cellStyle.getLeftBorderColor()));
                sb.append(Excel2Html.getBorderStyle(palette, 2, cellStyle.getBorderBottom(), cellStyle.getBottomBorderColor()));
            }
            sb.append("' ");
        }
    }

    private static String convertAlignToHtml(short alignment) {
        String align = "left";
        switch (alignment) {
            case 1: {
                align = "left";
                break;
            }
            case 2: {
                align = "center";
                break;
            }
            case 3: {
                align = "right";
                break;
            }
        }
        return align;
    }

    private static String convertVerticalAlignToHtml(short verticalAlignment) {
        String valign = "middle";
        switch (verticalAlignment) {
            case 2: {
                valign = "bottom";
                break;
            }
            case 1: {
                valign = "center";
                break;
            }
            case 0: {
                valign = "top";
                break;
            }
        }
        return valign;
    }

    private static String convertToStardColor(HSSFColor hc) {
        StringBuffer sb = new StringBuffer("");
        if (hc != null) {
            if (64 == hc.getIndex()) {
                return null;
            }
            sb.append("#");
            for (int i = 0; i < hc.getTriplet().length; ++i) {
                sb.append(Excel2Html.fillWithZero(Integer.toHexString(hc.getTriplet()[i])));
            }
        }
        return sb.toString();
    }

    private static String fillWithZero(String str) {
        if (str != null && str.length() < 2) {
            return "0" + str;
        }
        return str;
    }

    private static String getBorderStyle(HSSFPalette palette, int b, short s, short t) {
        if (s == 0) {
            return bordesr[b] + borderStyles[s] + "#d0d7e5 1px;";
        }
        String borderColorStr = Excel2Html.convertToStardColor(palette.getColor(t));
        borderColorStr = borderColorStr == null || borderColorStr.length() < 1 ? "#000000" : borderColorStr;
        return bordesr[b] + borderStyles[s] + borderColorStr + " 1px;";
    }

    private static String getBorderStyle(int b, short s, XSSFColor xc) {
        if (s == 0) {
            return bordesr[b] + borderStyles[s] + "#d0d7e5 1px;";
        }
        if (xc != null && !"".equals(xc)) {
            String borderColorStr = xc.getARGBHex();
            borderColorStr = borderColorStr == null || borderColorStr.length() < 1 ? "#000000" : borderColorStr.substring(2);
            return bordesr[b] + borderStyles[s] + borderColorStr + " 1px;";
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeFile(String content, String path) {
        OutputStream os = null;
        BufferedWriter bw = null;
        try {
            File file = new File(path);
            os = new FileOutputStream(file);
            bw = new BufferedWriter(new OutputStreamWriter(os));
            bw.write(content);
        }
        catch (FileNotFoundException fnfe) {
            fnfe.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        finally {
            try {
                if (bw != null) {
                    bw.close();
                }
                if (os != null) {
                    os.close();
                }
            }
            catch (IOException ie) {
                ie.printStackTrace();
            }
        }
    }
}

