/*
 * Decompiled with CFR 0.152.
 */
package com.kmall.common.utils.excel;

import com.kmall.common.utils.RRException;
import com.kmall.common.utils.excel.XssfDataType;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.poi.hssf.usermodel.HSSFDateUtil;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.openxml4j.exceptions.OpenXML4JException;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.xssf.eventusermodel.ReadOnlySharedStringsTable;
import org.apache.poi.xssf.eventusermodel.XSSFReader;
import org.apache.poi.xssf.model.StylesTable;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class Excel2007Reader
extends DefaultHandler {
    private ReadOnlySharedStringsTable sharedStringsTable;
    private final int minColumnCount = 0;
    private boolean vIsOpen;
    private XssfDataType nextDataType;
    private int thisColumn = -1;
    private int lastColumnNumber = 0;
    private StringBuffer value = new StringBuffer();
    private List<String> rowlist = new ArrayList<String>();
    private int sheetIndex = -1;
    private List<String[]> sheetData = new ArrayList<String[]>();
    private Map<Integer, List<String[]>> workData = new HashMap<Integer, List<String[]>>();
    private DataFormatter formatter;
    private short formatIndex;
    private String formatString;
    private StylesTable stylesTable;

    private void processSheet(ReadOnlySharedStringsTable strings, InputStream sheetInputStream) throws IOException, ParserConfigurationException, SAXException {
        ++this.sheetIndex;
        this.sharedStringsTable = strings;
        InputSource sheetSource = new InputSource(sheetInputStream);
        SAXParserFactory saxFactory = SAXParserFactory.newInstance();
        SAXParser saxParser = saxFactory.newSAXParser();
        XMLReader sheetParser = saxParser.getXMLReader();
        sheetParser.setContentHandler(this);
        sheetParser.parse(sheetSource);
    }

    public void process(InputStream fileStream, boolean isMuti) {
        try {
            OPCPackage xlsxPackage = OPCPackage.open((InputStream)fileStream);
            ReadOnlySharedStringsTable sharedStringsTable = new ReadOnlySharedStringsTable(xlsxPackage);
            XSSFReader xssfReader = new XSSFReader(xlsxPackage);
            this.stylesTable = xssfReader.getStylesTable();
            this.formatter = new DataFormatter();
            XSSFReader.SheetIterator iter = (XSSFReader.SheetIterator)xssfReader.getSheetsData();
            while (iter.hasNext()) {
                InputStream stream = iter.next();
                this.processSheet(sharedStringsTable, stream);
                stream.close();
                ArrayList<String[]> data = new ArrayList<String[]>();
                data.addAll(this.sheetData);
                this.workData.put(this.sheetIndex, data);
                this.sheetData.clear();
                if (isMuti) continue;
                break;
            }
        }
        catch (InvalidFormatException e) {
            throw new RRException("\u89e3\u6790EXCEL\u51fa\u9519");
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RRException("\u89e3\u6790EXCEL\u51fa\u9519");
        }
        catch (SAXException e) {
            e.printStackTrace();
            throw new RRException("\u89e3\u6790EXCEL\u51fa\u9519");
        }
        catch (OpenXML4JException e) {
            e.printStackTrace();
            throw new RRException("\u89e3\u6790EXCEL\u51fa\u9519");
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
            throw new RRException("\u89e3\u6790EXCEL\u51fa\u9519");
        }
    }

    @Override
    public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
        if ("inlineStr".equals(name) || "v".equals(name)) {
            this.vIsOpen = true;
            this.value.setLength(0);
        } else if ("c".equals(name)) {
            this.vIsOpen = false;
            String r = attributes.getValue("r");
            int firstDigit = -1;
            for (int c = 0; c < r.length(); ++c) {
                if (!Character.isDigit(r.charAt(c))) continue;
                firstDigit = c;
                break;
            }
            this.thisColumn = this.nameToColumn(r.substring(0, firstDigit));
            this.nextDataType = XssfDataType.NUMBER;
            String cellType = attributes.getValue("t");
            String cellStyleStr = attributes.getValue("s");
            if ("b".equals(cellType)) {
                this.nextDataType = XssfDataType.BOOL;
            } else if ("e".equals(cellType)) {
                this.nextDataType = XssfDataType.ERROR;
            } else if ("inlineStr".equals(cellType)) {
                this.nextDataType = XssfDataType.INLINESTR;
            } else if ("s".equals(cellType)) {
                this.nextDataType = XssfDataType.SSTINDEX;
            } else if ("str".equals(cellType)) {
                this.nextDataType = XssfDataType.FORMULA;
            } else if (cellStyleStr != null) {
                int styleIndex = Integer.parseInt(cellStyleStr);
                XSSFCellStyle style = this.stylesTable.getStyleAt(styleIndex);
                this.formatIndex = style.getDataFormat();
                this.formatString = style.getDataFormatString();
                if (this.formatIndex == 14 || this.formatIndex == 15 || this.formatIndex == 16 || this.formatIndex == 17) {
                    this.nextDataType = XssfDataType.DATE;
                } else if (this.formatIndex == 18 || this.formatIndex == 19 || this.formatIndex == 20 || this.formatIndex == 21 || this.formatIndex == 45 || this.formatIndex == 46 || this.formatIndex == 47) {
                    this.nextDataType = XssfDataType.TIME;
                } else if (this.formatIndex == 22) {
                    this.nextDataType = XssfDataType.DATETIME;
                }
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String name) throws SAXException {
        String thisStr = null;
        if ("v".equals(name)) {
            switch (this.nextDataType) {
                case BOOL: {
                    char first = this.value.charAt(0);
                    thisStr = first == '0' ? "FALSE" : "TRUE";
                    break;
                }
                case ERROR: {
                    thisStr = "\"ERROR:" + this.value.toString() + '\"';
                    break;
                }
                case FORMULA: {
                    thisStr = '\"' + this.value.toString() + '\"';
                    break;
                }
                case INLINESTR: {
                    XSSFRichTextString rtsi = new XSSFRichTextString(this.value.toString());
                    thisStr = rtsi.toString();
                    break;
                }
                case SSTINDEX: {
                    String sstIndex = this.value.toString();
                    try {
                        int idx = Integer.parseInt(sstIndex);
                        XSSFRichTextString rtss = new XSSFRichTextString(this.sharedStringsTable.getEntryAt(idx));
                        thisStr = rtss.toString();
                    }
                    catch (NumberFormatException idx) {}
                    break;
                }
                case NUMBER: {
                    String n = this.value.toString();
                    BigDecimal bd = new BigDecimal(n);
                    thisStr = bd.toString();
                    break;
                }
                case DATE: {
                    Date date = HSSFDateUtil.getJavaDate((double)Double.valueOf(this.value.toString()));
                    thisStr = new SimpleDateFormat("yyyy-MM-dd").format(date);
                    break;
                }
                case DATETIME: {
                    Date dateTime = HSSFDateUtil.getJavaDate((double)Double.valueOf(this.value.toString()));
                    thisStr = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(dateTime);
                    break;
                }
                case TIME: {
                    Date time = HSSFDateUtil.getJavaDate((double)Double.valueOf(this.value.toString()));
                    thisStr = new SimpleDateFormat("HH:mm:ss").format(time);
                    break;
                }
                default: {
                    thisStr = "(TODO: Unexpected type: " + (Object)((Object)this.nextDataType) + ")";
                }
            }
            for (int i = this.lastColumnNumber; i < this.thisColumn - 1; ++i) {
                this.rowlist.add("");
            }
            this.rowlist.add(thisStr);
            if (this.thisColumn > -1) {
                this.lastColumnNumber = this.thisColumn;
            }
        } else if ("row".equals(name)) {
            for (int i = this.lastColumnNumber; i < this.minColumnCount; ++i) {
                this.rowlist.add("");
            }
            this.lastColumnNumber = -1;
            this.sheetData.add(this.rowlist.toArray(new String[0]));
            this.rowlist.clear();
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.vIsOpen) {
            this.value.append(ch, start, length);
        }
    }

    private int nameToColumn(String name) {
        int column = -1;
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            column = (column + 1) * 26 + c - 65;
        }
        return column;
    }

    public List<String[]> getSheetData(Integer sheetIndex) {
        return this.workData.get(sheetIndex);
    }

    public Map<Integer, List<String[]>> getSheetData() {
        return this.workData;
    }

    public ReadOnlySharedStringsTable getSharedStringsTable() {
        return this.sharedStringsTable;
    }

    public void setSharedStringsTable(ReadOnlySharedStringsTable sharedStringsTable) {
        this.sharedStringsTable = sharedStringsTable;
    }

    public boolean isvIsOpen() {
        return this.vIsOpen;
    }

    public void setvIsOpen(boolean vIsOpen) {
        this.vIsOpen = vIsOpen;
    }

    public XssfDataType getNextDataType() {
        return this.nextDataType;
    }

    public void setNextDataType(XssfDataType nextDataType) {
        this.nextDataType = nextDataType;
    }

    public int getThisColumn() {
        return this.thisColumn;
    }

    public void setThisColumn(int thisColumn) {
        this.thisColumn = thisColumn;
    }

    public int getLastColumnNumber() {
        return this.lastColumnNumber;
    }

    public void setLastColumnNumber(int lastColumnNumber) {
        this.lastColumnNumber = lastColumnNumber;
    }

    public StringBuffer getValue() {
        return this.value;
    }

    public void setValue(StringBuffer value) {
        this.value = value;
    }

    public List<String> getRowlist() {
        return this.rowlist;
    }

    public void setRowlist(List<String> rowlist) {
        this.rowlist = rowlist;
    }

    public int getSheetIndex() {
        return this.sheetIndex;
    }

    public void setSheetIndex(int sheetIndex) {
        this.sheetIndex = sheetIndex;
    }

    public Map<Integer, List<String[]>> getWorkData() {
        return this.workData;
    }

    public void setWorkData(Map<Integer, List<String[]>> workData) {
        this.workData = workData;
    }

    public DataFormatter getFormatter() {
        return this.formatter;
    }

    public void setFormatter(DataFormatter formatter) {
        this.formatter = formatter;
    }

    public short getFormatIndex() {
        return this.formatIndex;
    }

    public void setFormatIndex(short formatIndex) {
        this.formatIndex = formatIndex;
    }

    public String getFormatString() {
        return this.formatString;
    }

    public void setFormatString(String formatString) {
        this.formatString = formatString;
    }

    public StylesTable getStylesTable() {
        return this.stylesTable;
    }

    public void setStylesTable(StylesTable stylesTable) {
        this.stylesTable = stylesTable;
    }

    public int getMinColumnCount() {
        return 0;
    }

    public void setSheetData(List<String[]> sheetData) {
        this.sheetData = sheetData;
    }
}

