/*
 * Decompiled with CFR 0.152.
 */
package com.kmall.common.utils.aes;

import com.kmall.common.exception.Exceptions;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.SecureRandom;
import org.apache.commons.lang3.Validate;

public class Digests {
    private static final String SHA1 = "SHA-1";
    private static final String MD5 = "MD5";
    private static SecureRandom random = new SecureRandom();

    public static byte[] md5(byte[] input) {
        return Digests.digest(input, MD5, null, 1);
    }

    public static byte[] md5(byte[] input, int iterations) {
        return Digests.digest(input, MD5, null, iterations);
    }

    public static byte[] sha1(byte[] input) {
        return Digests.digest(input, SHA1, null, 1);
    }

    public static byte[] sha1(byte[] input, byte[] salt) {
        return Digests.digest(input, SHA1, salt, 1);
    }

    public static byte[] sha1(byte[] input, byte[] salt, int iterations) {
        return Digests.digest(input, SHA1, salt, iterations);
    }

    private static byte[] digest(byte[] input, String algorithm, byte[] salt, int iterations) {
        try {
            MessageDigest digest = MessageDigest.getInstance(algorithm);
            if (salt != null) {
                digest.update(salt);
            }
            byte[] result = digest.digest(input);
            for (int i = 1; i < iterations; ++i) {
                digest.reset();
                result = digest.digest(result);
            }
            return result;
        }
        catch (GeneralSecurityException e) {
            throw Exceptions.unchecked(e);
        }
    }

    public static byte[] generateSalt(int numBytes) {
        Validate.isTrue((numBytes > 0 ? 1 : 0) != 0, (String)"numBytes argument must be a positive integer (1 or larger)", (long)numBytes);
        byte[] bytes = new byte[numBytes];
        random.nextBytes(bytes);
        return bytes;
    }

    public static byte[] md5(InputStream input) throws IOException {
        return Digests.digest(input, MD5);
    }

    public static byte[] sha1(InputStream input) throws IOException {
        return Digests.digest(input, SHA1);
    }

    private static byte[] digest(InputStream input, String algorithm) throws IOException {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance(algorithm);
            int bufferLength = 8192;
            byte[] buffer = new byte[bufferLength];
            int read = input.read(buffer, 0, bufferLength);
            while (read > -1) {
                messageDigest.update(buffer, 0, read);
                read = input.read(buffer, 0, bufferLength);
            }
            return messageDigest.digest();
        }
        catch (GeneralSecurityException e) {
            throw Exceptions.unchecked(e);
        }
    }

    private static byte[] md5(String s) {
        try {
            MessageDigest algorithm = MessageDigest.getInstance(MD5);
            algorithm.reset();
            algorithm.update(s.getBytes("UTF-8"));
            byte[] messageDigest = algorithm.digest();
            return messageDigest;
        }
        catch (Exception e) {
            System.out.println("MD5 Error..." + e);
            return null;
        }
    }

    private static final String toHex(byte[] hash) {
        if (hash == null) {
            return null;
        }
        StringBuffer buf = new StringBuffer(hash.length * 2);
        for (int i = 0; i < hash.length; ++i) {
            if ((hash[i] & 0xFF) < 16) {
                buf.append("0");
            }
            buf.append(Long.toString(hash[i] & 0xFF, 16));
        }
        return buf.toString();
    }

    public static String hash(String s) {
        try {
            return new String(Digests.toHex(Digests.md5(s)).getBytes("UTF-8"), "UTF-8");
        }
        catch (Exception e) {
            System.out.println("not supported charset...{}" + e);
            return s;
        }
    }
}

