/*
 * Decompiled with CFR 0.152.
 */
package com.kmall.common.utils.advice;

import com.alibaba.fastjson.JSONObject;
import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Aspect
public class WebRequestAroundAdvice {
    private static final Logger logger = LoggerFactory.getLogger(WebRequestAroundAdvice.class);

    @Pointcut(value="execution(* com.kmall.*.*.api.*.*(..))")
    public void pointcut() {
    }

    @Around(value="pointcut()")
    public Object handle(ProceedingJoinPoint joinPoint) throws Throwable {
        this.preHandle();
        Object retVal = joinPoint.proceed();
        this.postHandle(retVal);
        return retVal;
    }

    private void preHandle() {
        HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
        StringBuffer sb = new StringBuffer();
        sb.append("{");
        Enumeration headers = request.getHeaderNames();
        int i = 0;
        while (headers.hasMoreElements()) {
            String header = (String)headers.nextElement();
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(header + ": " + request.getHeader(header));
            ++i;
        }
        sb.append("}");
        logger.info("Pre handling request: {}, headers: {}", (Object)this.getRequestInfo(request, true), (Object)sb.toString());
    }

    private void postHandle(Object retVal) {
        HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
        logger.info("Post handling request: {}, response: {}", (Object)this.getRequestInfo(request, false), (Object)JSONObject.toJSONString((Object)retVal));
    }

    private String getRequestInfo(HttpServletRequest request, boolean requestDetails) {
        StringBuffer sb = new StringBuffer();
        sb.append(request.getMethod()).append(" ");
        sb.append(request.getRequestURI());
        if (requestDetails) {
            Enumeration e = request.getParameterNames();
            sb.append(" ").append("{");
            int i = 0;
            while (e.hasMoreElements()) {
                String name = (String)e.nextElement();
                String val = request.getParameter(name);
                if (val == null || val.isEmpty()) continue;
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(name).append(": ").append(val);
                ++i;
            }
            sb.append("}");
        }
        return sb.toString();
    }
}

