/*
 * Decompiled with CFR 0.152.
 */
package com.kmall.common.utils;

import com.kmall.common.utils.StringUtils;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class XmlUtil {
    public static Object xmlStrToBean(String xmlStr, Class clazz) {
        Object obj = null;
        try {
            Map<String, Object> map = XmlUtil.xmlStrToMap(xmlStr);
            obj = XmlUtil.mapToBean(map, clazz);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return obj;
    }

    public static Map<String, Object> xmlStrToMap(String xmlStr) throws Exception {
        if (StringUtils.isNullOrEmpty(xmlStr)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        Document doc = DocumentHelper.parseText((String)xmlStr);
        Element root = doc.getRootElement();
        List children = root.elements();
        if (children != null && children.size() > 0) {
            for (int i = 0; i < children.size(); ++i) {
                Element child = (Element)children.get(i);
                map.put(child.getName(), child.getTextTrim());
            }
        }
        return map;
    }

    public static Object xmlStrToJavaBean(String xmlStr, Class clazz) {
        if (StringUtils.isNullOrEmpty(xmlStr)) {
            return null;
        }
        Object obj = null;
        Map<String, Object> map = new HashMap<String, Object>();
        try {
            Document doc = DocumentHelper.parseText((String)xmlStr);
            Element root = doc.getRootElement();
            map = XmlUtil.elementToMap(root, map);
            obj = XmlUtil.mapToBean(map, clazz);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return obj;
    }

    public static Map<String, Object> elementToMap(Element element, Map<String, Object> map) {
        if (element == null || map == null) {
            return null;
        }
        List children = element.elements();
        if (children != null && children.size() > 0) {
            for (int i = 0; i < children.size(); ++i) {
                Element child = (Element)children.get(i);
                if (child.elements() != null && child.elements().size() > 0) {
                    XmlUtil.elementToMap(child, map);
                    continue;
                }
                map.put(child.getName(), child.getTextTrim());
            }
        }
        return map;
    }

    public static Object mapToBean(Map<String, Object> map, Class clazz) throws Exception {
        Object obj = clazz.newInstance();
        if (map != null && map.size() > 0) {
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                String propertyName = entry.getKey();
                Object value = entry.getValue();
                String setMethodName = "set" + propertyName.substring(0, 1).toUpperCase() + propertyName.substring(1);
                Field field = XmlUtil.getClassField(clazz, propertyName);
                if (field == null) continue;
                Class<?> fieldTypeClass = field.getType();
                value = XmlUtil.convertValType(value, fieldTypeClass);
                clazz.getMethod(setMethodName, field.getType()).invoke(obj, value);
            }
        }
        return obj;
    }

    private static Object convertValType(Object value, Class fieldTypeClass) {
        Object retVal = null;
        retVal = Long.class.getName().equals(fieldTypeClass.getName()) || Long.TYPE.getName().equals(fieldTypeClass.getName()) ? Long.valueOf(Long.parseLong(value.toString())) : (Integer.class.getName().equals(fieldTypeClass.getName()) || Integer.TYPE.getName().equals(fieldTypeClass.getName()) ? Integer.valueOf(Integer.parseInt(value.toString())) : (Float.class.getName().equals(fieldTypeClass.getName()) || Float.TYPE.getName().equals(fieldTypeClass.getName()) ? Float.valueOf(Float.parseFloat(value.toString())) : (Double.class.getName().equals(fieldTypeClass.getName()) || Double.TYPE.getName().equals(fieldTypeClass.getName()) ? Double.valueOf(Double.parseDouble(value.toString())) : value)));
        return retVal;
    }

    private static Field getClassField(Class clazz, String fieldName) {
        Field[] declaredFields;
        if (Object.class.getName().equals(clazz.getName())) {
            return null;
        }
        for (Field field : declaredFields = clazz.getDeclaredFields()) {
            if (!field.getName().equals(fieldName)) continue;
            return field;
        }
        Class superClass = clazz.getSuperclass();
        if (superClass != null) {
            return XmlUtil.getClassField(superClass, fieldName);
        }
        return null;
    }
}

