/*
 * Decompiled with CFR 0.152.
 */
package com.kmall.common.utils;

import java.util.Collection;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringUtils {
    public static final String EMPTY = "";
    private static Pattern linePattern = Pattern.compile("_(\\w)");

    public static boolean isNotEmpty(String str) {
        return str != null && !EMPTY.equals(str.trim()) && !"null".equalsIgnoreCase(str);
    }

    public static boolean isNullOrEmpty(Object obj) {
        if (obj == null) {
            return true;
        }
        if (obj instanceof CharSequence) {
            return ((CharSequence)obj).length() == 0;
        }
        if (obj instanceof Collection) {
            return ((Collection)obj).isEmpty();
        }
        if (obj instanceof Map) {
            return ((Map)obj).isEmpty();
        }
        if (obj instanceof Object[]) {
            Object[] object = (Object[])obj;
            if (object.length == 0) {
                return true;
            }
            boolean empty = true;
            for (int i = 0; i < object.length; ++i) {
                if (StringUtils.isNullOrEmpty(object[i])) continue;
                empty = false;
                break;
            }
            return empty;
        }
        return false;
    }

    public static String lineToHump(String str) {
        str = str.toLowerCase();
        Matcher matcher = linePattern.matcher(str);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(sb, matcher.group(1).toUpperCase());
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    public static boolean checkNumberByTwoDecimal(String value) {
        String str = String.valueOf(value);
        String regEx = "\\d+(\\.\\d{1,2})?";
        Pattern pattern = Pattern.compile(regEx);
        Matcher matcher = pattern.matcher(str);
        boolean rs = matcher.matches();
        return rs;
    }

    public static boolean checkNumberByOneDecimal(String value) {
        String str = String.valueOf(value);
        String regEx = "\\d+(\\.\\d{1,1})?";
        Pattern pattern = Pattern.compile(regEx);
        Matcher matcher = pattern.matcher(str);
        boolean rs = matcher.matches();
        return rs;
    }

    public static boolean checkNumberByInteger(String value) {
        String str = String.valueOf(value);
        String regEx = "[+]{0,1}(\\d+)";
        Pattern pattern = Pattern.compile(regEx);
        Matcher matcher = pattern.matcher(str);
        boolean rs = matcher.matches();
        return rs;
    }

    public static void main(String[] args) {
        boolean rs = StringUtils.checkNumberByTwoDecimal("1");
        System.out.println(rs);
        boolean rs2 = StringUtils.checkNumberByInteger("1");
        System.out.println(rs2);
        boolean rs3 = StringUtils.checkNumberByOneDecimal("1.11");
        System.out.println(rs3);
    }
}

