/*
 * Decompiled with CFR 0.152.
 */
package com.kmall.common.utils;

import com.kmall.common.utils.StringUtils;
import java.io.UnsupportedEncodingException;
import java.util.ResourceBundle;
import javax.servlet.http.HttpServletRequest;

public final class ResourceUtil {
    private static ResourceUtil RESOURCE_UTIL = null;
    private static ResourceBundle BUNDLE = null;

    private ResourceUtil() {
    }

    private static ResourceBundle getBundle(String propertiesName) {
        return ResourceBundle.getBundle(propertiesName);
    }

    public static ResourceUtil getInstance(String properties) {
        if (RESOURCE_UTIL == null) {
            RESOURCE_UTIL = new ResourceUtil();
        }
        if (properties != null) {
            BUNDLE = ResourceBundle.getBundle(properties);
        }
        return RESOURCE_UTIL;
    }

    public static ResourceUtil getInstance() {
        if (RESOURCE_UTIL == null) {
            RESOURCE_UTIL = new ResourceUtil();
        }
        return RESOURCE_UTIL;
    }

    public static String getRequestPath(HttpServletRequest request) {
        String requestPath = request.getRequestURI() + "?" + request.getQueryString();
        if (requestPath.indexOf("&") > -1) {
            requestPath = requestPath.substring(0, requestPath.indexOf("&"));
        }
        requestPath = requestPath.substring(request.getContextPath().length() + 1);
        return requestPath;
    }

    public static String getConfigByName(String propertiesName, String name) {
        String value = "";
        try {
            value = new String(ResourceUtil.getBundle(propertiesName).getString(name).getBytes("iso8859-1"), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return value;
    }

    public static String getConfigByName(String name) {
        String value = "";
        try {
            value = new String(BUNDLE.getString(name).getBytes("iso8859-1"), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return value;
    }

    public static String getSysPath() {
        String path = Thread.currentThread().getContextClassLoader().getResource("").toString();
        String temp = path.replaceFirst("file:/", "").replaceFirst("WEB-INF/classes/", "");
        String separator = System.getProperty("file.separator");
        String resultPath = temp.replaceAll("/", separator + separator).replaceAll("%20", " ");
        return resultPath;
    }

    public static String getPorjectPath() {
        String nowpath = System.getProperty("user.dir");
        String tempdir = nowpath.replace("bin", "webapps");
        tempdir = tempdir + "\\";
        return tempdir;
    }

    public static String getClassPath() {
        String path = Thread.currentThread().getContextClassLoader().getResource("").toString();
        String temp = path.replaceFirst("file:/", "");
        String separator = System.getProperty("file.separator");
        String resultPath = temp.replaceAll("/", separator + separator);
        return resultPath;
    }

    public static String getSystempPath() {
        return System.getProperty("java.io.tmpdir");
    }

    public static String getSeparator() {
        return System.getProperty("file.separator");
    }

    public String getDbType() {
        return StringUtils.isNullOrEmpty(ResourceBundle.getBundle("platform").getString("dbType")) ? "oracle" : ResourceBundle.getBundle("platform").getString("dbType");
    }

    public String getDbSchema() {
        String schema = "";
        if (StringUtils.isNotEmpty(ResourceBundle.getBundle("platform").getString("dbType")) && "db2".equals(ResourceBundle.getBundle("platform").getString("dbType"))) {
            schema = StringUtils.isNotEmpty(ResourceBundle.getBundle("platform").getString("dbSchema")) ? ResourceBundle.getBundle("platform").getString("dbSchema") + "." : "";
        }
        return schema;
    }
}

