/*
 * Decompiled with CFR 0.152.
 */
package com.kmall.common.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONObject;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class RequestUtil {
    private static final Log LOGGER = LogFactory.getLog((String)RequestUtil.class.getName());

    public static Map<String, Object> getParameters(HttpServletRequest request, boolean printLog) {
        Enumeration enume = request.getParameterNames();
        HashMap<String, Object> map = new HashMap<String, Object>();
        while (enume.hasMoreElements()) {
            String key = (String)enume.nextElement();
            String value = request.getParameter(key);
            map.put(key, value);
            if (!printLog) continue;
            LOGGER.info((Object)(key + "==>" + value));
        }
        if (map.get("sortOrder") != null) {
            map.put("sortOrder", "asc");
        }
        return map;
    }

    public static Map<String, Object> getParameters(HttpServletRequest request) {
        return RequestUtil.getParameters(request, false);
    }

    public static String getClientIp(HttpServletRequest request) {
        String xff = request.getHeader("x-forwarded-for");
        if (xff == null) {
            return request.getRemoteAddr();
        }
        return xff;
    }

    public static String getIpAddrByRequest(HttpServletRequest request) {
        String ip = request.getHeader("x-forwarded-for");
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
        }
        return ip;
    }

    public static String getRequestUrl(HttpServletRequest request) {
        return request.getRequestURL().toString();
    }

    public static HttpServletRequest getCurrentRequest() {
        return ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, Object> getBody(HttpServletRequest request) {
        String body = null;
        StringBuilder stringBuilder = new StringBuilder();
        BufferedReader bufferedReader = null;
        try {
            ServletInputStream inputStream = request.getInputStream();
            if (inputStream != null) {
                bufferedReader = new BufferedReader(new InputStreamReader((InputStream)inputStream));
                char[] charBuffer = new char[128];
                int bytesRead = -1;
                while ((bytesRead = bufferedReader.read(charBuffer)) > 0) {
                    stringBuilder.append(charBuffer, 0, bytesRead);
                }
            } else {
                stringBuilder.append("");
            }
        }
        catch (IOException inputStream) {
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException inputStream) {}
            }
        }
        body = stringBuilder.toString();
        JSONObject json = new JSONObject(body);
        HashMap<String, Object> paramers = new HashMap<String, Object>();
        Iterator keys = json.keys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            paramers.put(key, json.get(key));
        }
        return paramers;
    }
}

