/*
 * Decompiled with CFR 0.152.
 */
package com.kmall.common.utils;

import com.google.common.collect.Maps;
import com.kmall.common.utils.ApiRRException;
import com.kmall.common.utils.R;
import com.kmall.common.utils.RRException;
import java.util.HashMap;
import org.apache.shiro.authz.AuthorizationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;

@RestControllerAdvice
public class RRExceptionHandler {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @ExceptionHandler(value={RRException.class})
    public R handleRRException(RRException e) {
        R r = new R();
        r.put("code", (Object)e.getCode());
        r.put("msg", (Object)e.getMessage());
        return r;
    }

    @ExceptionHandler(value={DuplicateKeyException.class})
    public R handleDuplicateKeyException(DuplicateKeyException e) {
        this.logger.error(e.getMessage(), (Throwable)e);
        return R.error("\u6570\u636e\u5e93\u4e2d\u5df2\u5b58\u5728\u8be5\u8bb0\u5f55");
    }

    @ExceptionHandler(value={AuthorizationException.class})
    public R handleAuthorizationException(AuthorizationException e) {
        this.logger.error(e.getMessage(), (Throwable)e);
        return R.error("\u6ca1\u6709\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u6388\u6743");
    }

    @ExceptionHandler(value={Exception.class})
    public R handleException(Exception e) {
        this.logger.error(e.getMessage(), (Throwable)e);
        return R.error();
    }

    @ExceptionHandler(value={ApiRRException.class})
    public Object handleApiRRException(ApiRRException e) {
        HashMap result = Maps.newHashMap();
        result.put("errno", e.getErrno());
        result.put("errmsg", e.getErrmsg());
        return result;
    }
}

