/*
 * Decompiled with CFR 0.152.
 */
package com.kmall.common.utils;

import com.kmall.common.utils.JacksonUtils;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.FormBody;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OkHttpUtils {
    private static final Logger logger = LoggerFactory.getLogger(OkHttpUtils.class);
    public static final MediaType MEDIA_TYPE_JSON = MediaType.parse((String)"application/json;charset=UTF-8");
    public static final MediaType MEDIA_TYPE_XML = MediaType.parse((String)"application/xml;charset=UTF-8");
    public static final MediaType MEDIA_TYPE_TEXT_HTML = MediaType.parse((String)"text/html;charset=UTF-8");
    private static final MediaType MEDIA_TYPE_FORM = MediaType.parse((String)"application/x-www-form-urlencoded");
    private static final String SSL = "SSL";
    public static final int CONNECT_TIME_OUT = 20;
    public static final int READ_TIME = 30;
    public static final int WRITE_TIME = 30;
    private static final ThreadLocal<OkHttpClient> okHttpClientThreadLocal = new ThreadLocal();
    private static final ThreadLocal<OkHttpClient> okHttpClientSslThreadLocal = new ThreadLocal();

    private OkHttpUtils() {
    }

    private static OkHttpClient okHttpClient() {
        return OkHttpUtils.okHttpClient(null);
    }

    private static OkHttpClient okHttpClient(String ssl) {
        return StringUtils.isNotBlank((CharSequence)ssl) && SSL.equals(ssl) ? OkHttpUtils.okHttpInstanceSsl() : OkHttpUtils.okHttpInstance();
    }

    private static OkHttpClient okHttpClient(String ssl, boolean ignoreHostnameVerifier, InputStream ... certificates) {
        return StringUtils.isNotBlank((CharSequence)ssl) && SSL.equalsIgnoreCase(ssl) ? OkHttpUtils.okHttpInstanceSsl(ignoreHostnameVerifier, certificates) : OkHttpUtils.okHttpInstance();
    }

    private static OkHttpClient okHttpInstance() {
        OkHttpClient client = okHttpClientThreadLocal.get();
        if (client == null) {
            OkHttpClient.Builder builder = new OkHttpClient.Builder();
            builder.connectTimeout(20L, TimeUnit.SECONDS).readTimeout(30L, TimeUnit.SECONDS).writeTimeout(30L, TimeUnit.SECONDS).retryOnConnectionFailure(true);
            client = builder.build();
            okHttpClientThreadLocal.set(client);
        }
        return client;
    }

    private static OkHttpClient okHttpInstanceSsl() {
        return OkHttpUtils.okHttpInstanceSsl(true, null);
    }

    private static OkHttpClient okHttpInstanceSsl(boolean ignoreHostnameVerifier, InputStream ... certificates) {
        OkHttpClient client = okHttpClientSslThreadLocal.get();
        if (client == null) {
            TrustManager[] trustManager = OkHttpUtils.buildX509TrustManager(certificates);
            SSLSocketFactory sslSocketFactory = OkHttpUtils.buildSSLSocketFactory(trustManager);
            OkHttpClient.Builder builder = new OkHttpClient.Builder();
            builder.connectTimeout(20L, TimeUnit.SECONDS).readTimeout(30L, TimeUnit.SECONDS).writeTimeout(30L, TimeUnit.SECONDS);
            if (ignoreHostnameVerifier) {
                builder.hostnameVerifier(OkHttpUtils.getHostnameVerifier());
            }
            builder.sslSocketFactory(sslSocketFactory, (X509TrustManager)trustManager[0]).retryOnConnectionFailure(true);
            client = builder.build();
            okHttpClientSslThreadLocal.set(client);
        }
        return client;
    }

    public static RequestBody buildRequestBody(MediaType mediaType, String json) {
        return RequestBody.create((MediaType)mediaType, (String)json);
    }

    public static RequestBody buildRequestBody(String key, Object value) {
        if (StringUtils.isBlank((CharSequence)key)) {
            return null;
        }
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put(key, value);
        return OkHttpUtils.buildRequestBody(param);
    }

    public static RequestBody buildMapStringRequestBody(Map<String, String> params) {
        FormBody.Builder builder = new FormBody.Builder();
        for (Map.Entry<String, String> entry : params.entrySet()) {
            builder.add(entry.getKey(), entry.getValue());
        }
        return builder.build();
    }

    public static RequestBody buildRequestBody(Map<String, Object> params) {
        FormBody.Builder builder = new FormBody.Builder();
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            builder.add(entry.getKey(), entry.getValue() == null ? "" : JacksonUtils.toJson(entry.getValue()));
        }
        return builder.build();
    }

    public static Request buildRequest(String json, String url, String type) {
        MediaType mediaType = MEDIA_TYPE_JSON;
        if (type.equalsIgnoreCase("text_html")) {
            mediaType = MEDIA_TYPE_TEXT_HTML;
        } else if (type.equalsIgnoreCase("form")) {
            mediaType = MEDIA_TYPE_FORM;
        } else if (type.equalsIgnoreCase("xml")) {
            mediaType = MEDIA_TYPE_XML;
        }
        RequestBody body = OkHttpUtils.buildRequestBody(mediaType, json);
        return OkHttpUtils.buildRequest(body, url);
    }

    public static Request buildStringRequest(Map<String, String> param, String url) {
        return OkHttpUtils.buildRequest(OkHttpUtils.buildMapStringRequestBody(param), url);
    }

    public static Request buildRequest(Map<String, Object> param, String url) {
        return OkHttpUtils.buildRequest(OkHttpUtils.buildRequestBody(param), url);
    }

    public static Request buildRequest(String key, Object value, String url) {
        return OkHttpUtils.buildRequest(OkHttpUtils.buildRequestBody(key, value), url);
    }

    public static Request buildRequest(RequestBody body, String url) {
        return new Request.Builder().url(url).post(body).build();
    }

    public static String post(String json, String url, String type, String ssl) {
        return OkHttpUtils.post(OkHttpUtils.buildRequest(json, url, type), ssl);
    }

    public static String post(String key, Object value, String url, String ssl) {
        return OkHttpUtils.post(OkHttpUtils.buildRequest(key, value, url), ssl);
    }

    public static String postString(Map<String, String> param, String url, String ssl) {
        return OkHttpUtils.post(OkHttpUtils.buildStringRequest(param, url), ssl);
    }

    public static String post(Map<String, Object> param, String url, String ssl) {
        return OkHttpUtils.post(OkHttpUtils.buildRequest(param, url), ssl);
    }

    public static String post(Request request, String ssl) {
        String result = "";
        try {
            Response response = OkHttpUtils.okHttpClient(ssl).newCall(request).execute();
            if (response.isSuccessful()) {
                result = response.body().string();
            } else {
                logger.error("okhttp3 post failed.");
            }
        }
        catch (IOException e) {
            logger.error("okhttp3 post throw IOException, {}", (Object)e.getMessage());
        }
        return result;
    }

    public static String postReturnResponse(Request request, String ssl) {
        try {
            return OkHttpUtils.okHttpClient(ssl).newCall(request).execute().body().string();
        }
        catch (IOException e) {
            logger.error("okhttp3 post throw IOException, {}", (Object)e.getMessage());
            return null;
        }
    }

    public static void asyncPostCallback(Request request, String ssl, Callback responseCallback) {
        OkHttpUtils.okHttpClient(ssl).newCall(request).enqueue(responseCallback);
    }

    public static void asyncPost(Request request, String ssl) {
        OkHttpUtils.okHttpClient(ssl).newCall(request).enqueue(new Callback(){

            public void onFailure(Call call, IOException e) {
            }

            public void onResponse(Call call, Response response) throws IOException {
            }
        });
    }

    public static HostnameVerifier getHostnameVerifier() {
        return new HostnameVerifier(){

            @Override
            public boolean verify(String s, SSLSession sslSession) {
                return true;
            }
        };
    }

    private static KeyStore generateKeyStore(InputStream ... certificates) {
        try {
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            keyStore.load(null);
            int index = 0;
            if (certificates != null && certificates.length > 0) {
                for (InputStream certificate : certificates) {
                    String certificateAlias = Integer.toString(index++);
                    keyStore.setCertificateEntry(certificateAlias, certificateFactory.generateCertificate(certificate));
                    try {
                        if (certificate == null) continue;
                        certificate.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
            return keyStore;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static X509TrustManager[] buildX509TrustManager() {
        return OkHttpUtils.buildX509TrustManager(null);
    }

    private static X509TrustManager[] buildX509TrustManager(InputStream ... certificates) {
        try {
            if (certificates == null) {
                return new X509TrustManager[]{new X509TrustManager(){

                    @Override
                    public void checkClientTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
                    }

                    @Override
                    public void checkServerTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
                    }

                    @Override
                    public X509Certificate[] getAcceptedIssuers() {
                        return new X509Certificate[0];
                    }
                }};
            }
            KeyStore keyStore = OkHttpUtils.generateKeyStore(certificates);
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init(keyStore);
            Object[] trustManagers = trustManagerFactory.getTrustManagers();
            if (trustManagers.length != 1 || !(trustManagers[0] instanceof X509TrustManager)) {
                throw new IllegalStateException("Unexpected default trust managers:" + Arrays.toString(trustManagers));
            }
            return (X509TrustManager[])trustManagers;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static SSLSocketFactory buildSSLSocketFactory() {
        return OkHttpUtils.buildSSLSocketFactory(new InputStream[]{null});
    }

    private static SSLSocketFactory buildSSLSocketFactory(InputStream ... certificates) {
        try {
            TrustManager[] trustManager = OkHttpUtils.buildX509TrustManager(certificates);
            return OkHttpUtils.buildSSLSocketFactory(trustManager);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static SSLSocketFactory buildSSLSocketFactory(TrustManager[] trustManager) {
        try {
            if (trustManager == null) {
                throw new IllegalStateException("TrustManager is null");
            }
            SSLContext sslContext = SSLContext.getInstance(SSL);
            sslContext.init(null, trustManager, new SecureRandom());
            return sslContext.getSocketFactory();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

