/*
 * Decompiled with CFR 0.152.
 */
package com.kmall.common.utils;

import com.kmall.common.utils.DateUtils;
import com.kmall.common.utils.StringUtils;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.beanutils.DynaBean;
import org.apache.commons.beanutils.DynaProperty;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.beanutils.PropertyUtilsBean;

public class MyBeanUtils
extends PropertyUtilsBean {
    private static void convert(Object dest, Object orig) throws IllegalAccessException, InvocationTargetException {
        if (dest == null) {
            throw new IllegalArgumentException("No destination bean specified");
        }
        if (orig == null) {
            throw new IllegalArgumentException("No origin bean specified");
        }
        if (orig instanceof DynaBean) {
            DynaProperty[] origDescriptors = ((DynaBean)orig).getDynaClass().getDynaProperties();
            for (int i = 0; i < origDescriptors.length; ++i) {
                String name = origDescriptors[i].getName();
                if (!PropertyUtils.isWriteable((Object)dest, (String)name)) continue;
                Object value2 = ((DynaBean)orig).get(name);
                try {
                    MyBeanUtils.getInstance().setSimpleProperty(dest, name, value2);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        } else if (orig instanceof Map) {
            for (String name : ((Map)orig).keySet()) {
                if (!PropertyUtils.isWriteable((Object)dest, (String)name)) continue;
                Object value = ((Map)orig).get(name);
                try {
                    MyBeanUtils.getInstance().setSimpleProperty(dest, name, value);
                }
                catch (Exception value2) {}
            }
        } else {
            PropertyDescriptor[] origDescriptors = PropertyUtils.getPropertyDescriptors((Object)orig);
            for (int i = 0; i < origDescriptors.length; ++i) {
                String name = origDescriptors[i].getName();
                if ("class".equals(name) || !PropertyUtils.isReadable((Object)orig, (String)name) || !PropertyUtils.isWriteable((Object)dest, (String)name)) continue;
                try {
                    Object value = PropertyUtils.getSimpleProperty((Object)orig, (String)name);
                    MyBeanUtils.getInstance().setSimpleProperty(dest, name, value);
                    continue;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public static void copyBeanNotNull2Bean(Object databean, Object tobean) throws Exception {
        PropertyDescriptor[] origDescriptors = PropertyUtils.getPropertyDescriptors((Object)databean);
        for (int i = 0; i < origDescriptors.length; ++i) {
            String name = origDescriptors[i].getName();
            if ("class".equals(name) || !PropertyUtils.isReadable((Object)databean, (String)name) || !PropertyUtils.isWriteable((Object)tobean, (String)name)) continue;
            try {
                Object value = PropertyUtils.getSimpleProperty((Object)databean, (String)name);
                if (value == null) continue;
                MyBeanUtils.getInstance().setSimpleProperty(tobean, name, value);
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void copyBean2Bean(Object dest, Object orig) throws Exception {
        MyBeanUtils.convert(dest, orig);
    }

    public static void copyBean2Map(Map map, Object bean) {
        PropertyDescriptor[] pds = PropertyUtils.getPropertyDescriptors((Object)bean);
        for (int i = 0; i < pds.length; ++i) {
            PropertyDescriptor pd = pds[i];
            String propname = pd.getName();
            try {
                Object propvalue = PropertyUtils.getSimpleProperty((Object)bean, (String)propname);
                map.put(propname, propvalue);
                continue;
            }
            catch (IllegalAccessException illegalAccessException) {
                continue;
            }
            catch (InvocationTargetException invocationTargetException) {
                continue;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
    }

    public static void copyBean2Map(Map map, Object bean, List<String> fieldNameList) {
        for (int i = 0; i < fieldNameList.size(); ++i) {
            String oldPropname = fieldNameList.get(i);
            String propname = StringUtils.lineToHump(oldPropname);
            try {
                Object propvalue = MyBeanUtils.getProp(bean, propname);
                map.put(oldPropname, propvalue);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void copyMap2Bean(Object bean, Map properties) {
        if (bean == null || properties == null) {
            return;
        }
        for (String name : properties.keySet()) {
            if (name == null) continue;
            Object value = properties.get(name);
            try {
                String className;
                Class clazz = PropertyUtils.getPropertyType((Object)bean, (String)(name = StringUtils.lineToHump(name)));
                if (null == clazz || (className = clazz.getName()).equalsIgnoreCase("java.sql.Timestamp") && (value == null || value.equals(""))) continue;
                if (className.equalsIgnoreCase("int")) {
                    if (value == null || value.equals("")) continue;
                    value = ((BigDecimal)value).intValue();
                }
                if (className.equalsIgnoreCase("long")) {
                    if (value == null || value.equals("")) continue;
                    value = ((BigDecimal)value).longValue();
                }
                if (className.equalsIgnoreCase("java.lang.Long")) {
                    if (value == null || value.equals("")) continue;
                    value = ((BigDecimal)value).longValue();
                }
                if (className.equalsIgnoreCase("java.lang.Integer")) {
                    if (value == null || value.equals("")) continue;
                    value = Integer.parseInt(value + "");
                }
                MyBeanUtils.getInstance().setSimpleProperty(bean, name, value);
            }
            catch (Exception e) {}
        }
    }

    public static void copyMap2BeanNobig(Object bean, Map properties) throws IllegalAccessException, InvocationTargetException {
        if (bean == null || properties == null) {
            return;
        }
        for (String name : properties.keySet()) {
            if (name == null) continue;
            Object value = properties.get(name);
            try {
                Class clazz;
                if (value == null || null == (clazz = PropertyUtils.getPropertyType((Object)bean, (String)name))) continue;
                String className = clazz.getName();
                if (className.equalsIgnoreCase("java.util.Date")) {
                    value = new Date(((Timestamp)value).getTime());
                }
                MyBeanUtils.getInstance().setSimpleProperty(bean, name, value);
            }
            catch (NoSuchMethodException e) {}
        }
    }

    public static void copyMap2Bean(Object bean, Map properties, String defaultValue) throws IllegalAccessException, InvocationTargetException {
        if (bean == null || properties == null) {
            return;
        }
        for (String name : properties.keySet()) {
            if (name == null) continue;
            Object value = properties.get(name);
            try {
                String className;
                Class clazz = PropertyUtils.getPropertyType((Object)bean, (String)name);
                if (null == clazz || (className = clazz.getName()).equalsIgnoreCase("java.sql.Timestamp") && (value == null || value.equals(""))) continue;
                if (className.equalsIgnoreCase("java.lang.String") && value == null) {
                    value = defaultValue;
                }
                MyBeanUtils.getInstance().setSimpleProperty(bean, name, value);
            }
            catch (NoSuchMethodException e) {}
        }
    }

    public static List<Field> findAllFieldsOfSelfAndSuperClass(Class clazz) {
        Field[] fields = null;
        ArrayList<Field> fieldList = new ArrayList<Field>();
        while (clazz != null) {
            fields = clazz.getDeclaredFields();
            for (int i = 0; i < fields.length; ++i) {
                fieldList.add(fields[i]);
            }
            clazz = clazz.getSuperclass();
        }
        return fieldList;
    }

    public static Map<String, Object> convertBean2Map(Object obj, String[] ignores) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        List<Field> fieldList = MyBeanUtils.findAllFieldsOfSelfAndSuperClass(obj.getClass());
        Field field = null;
        try {
            for (int i = 0; i < fieldList.size(); ++i) {
                Object value;
                field = fieldList.get(i);
                boolean flag = false;
                if (ignores != null && ignores.length != 0) {
                    flag = MyBeanUtils.isExistOfIgnores(field.getName(), ignores);
                }
                if (flag || null == (value = MyBeanUtils.getProp(obj, field.getName())) || "".equals(value.toString())) continue;
                map.put(field.getName(), MyBeanUtils.getProp(obj, field.getName()));
            }
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        return map;
    }

    public static Map<String, Object> convertBean2Map(Object obj) {
        return MyBeanUtils.convertBean2Map(obj, null);
    }

    public static Map<String, Object> convertBean2MapForIngoreserialVersionUID(Object obj) {
        return MyBeanUtils.convertBean2Map(obj, new String[]{"serialVersionUID"});
    }

    private static boolean isExistOfIgnores(String fieldName, String[] ignores) {
        boolean flag = false;
        for (String str : ignores) {
            if (!str.equals(fieldName)) continue;
            flag = true;
            break;
        }
        return flag;
    }

    public static PropertyDescriptor getPropertyDescriptor(Class<Object> clazz, String propertyName) {
        StringBuffer sb = new StringBuffer();
        Method setMethod = null;
        Method getMethod = null;
        PropertyDescriptor pd = null;
        try {
            Field f = clazz.getDeclaredField(propertyName);
            if (f != null) {
                String methodEnd = propertyName.substring(0, 1).toUpperCase() + propertyName.substring(1);
                sb.append("set" + methodEnd);
                setMethod = clazz.getDeclaredMethod(sb.toString(), f.getType());
                sb.delete(0, sb.length());
                sb.append("get" + methodEnd);
                getMethod = clazz.getDeclaredMethod(sb.toString(), new Class[0]);
                pd = new PropertyDescriptor(propertyName, getMethod, setMethod);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return pd;
    }

    public static void setProp(Object obj, String propertyName, Object value) {
        Class<Object> clazz = obj.getClass();
        PropertyDescriptor pd = MyBeanUtils.getPropertyDescriptor(clazz, propertyName);
        Method setMethod = pd.getWriteMethod();
        try {
            setMethod.invoke(obj, value);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Object getProp(Object obj, String propertyName) {
        Class<Object> clazz = obj.getClass();
        PropertyDescriptor pd = MyBeanUtils.getPropertyDescriptor(clazz, propertyName);
        Method getMethod = pd.getReadMethod();
        Object value = null;
        try {
            value = getMethod.invoke(obj, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return value;
    }

    public static Object map2Object(Map<String, Object> map, Class<?> clazz) {
        if (map == null) {
            return null;
        }
        Object obj = null;
        try {
            Map<String, Object> datas = map;
            obj = Class.forName(clazz.getName()).newInstance();
            Method[] ms = clazz.getDeclaredMethods();
            Field[] fs = clazz.getDeclaredFields();
            Set<String> keys = datas.keySet();
            for (int i = 0; i < fs.length; ++i) {
                String fieldname = fs[i].getName();
                Object val = null;
                String type = fs[i].getGenericType().toString().split("[.]")[fs[i].getGenericType().toString().split("[.]").length - 1];
                try {
                    for (Method m : ms) {
                        Class<?> paramType;
                        String temp = m.getName();
                        if (!temp.startsWith("set")) continue;
                        String tmp = temp.substring(3, 4).toLowerCase() + temp.substring(4);
                        if (!MyBeanUtils.igFirstChar(fieldname).equals(MyBeanUtils.igFirstChar(tmp))) continue;
                        String keyName = MyBeanUtils.getAnnotationValue(fs[i].getAnnotations());
                        if ("".equals(keyName) && "".equals(keyName = MyBeanUtils.getAnnotationValue(clazz.getDeclaredMethod("get" + temp.substring(3), null).getAnnotations()))) {
                            keyName = MyBeanUtils.turnToTable(tmp, m.getAnnotations());
                        }
                        if (!keys.contains(keyName.toUpperCase())) {
                            boolean can = true;
                            int isMore = 0;
                            for (String str : keys) {
                                String temp_str = str.replaceAll("_", "");
                                String temp_field = fieldname.replaceAll("_", "");
                                if (!temp_str.toLowerCase().equals(temp_field.toLowerCase())) continue;
                                if (isMore > 0) {
                                    throw new RuntimeException("java\u5b57\u6bb5" + temp_str + "\u5728\u6570\u636e\u5e93\u4e2d\u6709\u591a\u4e2a\u5b57\u6bb5\u76f8\u5bf9\u5e94\uff01");
                                }
                                val = datas.get(str);
                                can = false;
                                ++isMore;
                            }
                            if (can) {
                                String msg = "";
                                msg = "[\u8b66\u544a]:" + clazz.getName() + "." + fieldname + "\u5728\u6570\u636e\u5e93\u4e2d\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u5b57\u6bb5\uff01";
                            }
                        } else {
                            val = datas.get(keyName.toUpperCase());
                        }
                        if (val == null || !String.class.equals(paramType = m.getParameterTypes()[0]) && "".equals(val)) continue;
                        if ("String".equals(paramType.getSimpleName())) {
                            m.invoke(obj, m.getParameterTypes()[0].getConstructor(String.class).newInstance(val.toString()));
                            continue;
                        }
                        if ("Double".equals(paramType.getSimpleName()) || "double".equals(paramType.getSimpleName())) {
                            m.invoke(obj, Double.parseDouble(val.toString()));
                            continue;
                        }
                        if ("Long".equals(paramType.getSimpleName()) || "long".equals(paramType.getSimpleName())) {
                            m.invoke(obj, Long.parseLong(val.toString()));
                            continue;
                        }
                        if ("Integer".equals(paramType.getSimpleName()) || "int".equals(paramType.getSimpleName())) {
                            m.invoke(obj, Integer.parseInt(val.toString()));
                            continue;
                        }
                        if ("BigInteger".equals(paramType.getSimpleName())) {
                            m.invoke(obj, new BigInteger(val.toString()));
                            continue;
                        }
                        if ("Date".equals(paramType.getSimpleName())) {
                            m.invoke(obj, DateUtils.strToDate(val.toString()));
                            continue;
                        }
                        if ("Short".equals(paramType.getSimpleName())) {
                            m.invoke(obj, Short.parseShort(val.toString()));
                            continue;
                        }
                        if ("Byte".equals(paramType.getSimpleName()) || "byte".equals(paramType.getSimpleName())) {
                            m.invoke(obj, Byte.parseByte(val.toString()));
                            continue;
                        }
                        if ("char".equals(paramType.getSimpleName())) {
                            if (val.toString().length() == 0) continue;
                            m.invoke(obj, Character.valueOf(val.toString().charAt(0)));
                            continue;
                        }
                        if ("Character".equals(paramType.getSimpleName())) {
                            if (val.toString().length() == 0) continue;
                            m.invoke(obj, Character.valueOf(val.toString().charAt(0)));
                            continue;
                        }
                        if (val.getClass().equals(paramType)) {
                            m.invoke(obj, val);
                            continue;
                        }
                        m.invoke(obj, m.getParameterTypes()[0].getConstructor(String.class).newInstance(val.toString()));
                    }
                    continue;
                }
                catch (Exception e) {
                    throw new RuntimeException(e.getMessage());
                }
            }
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        return obj;
    }

    private static String igFirstChar(String fieldName) {
        if (fieldName == null) {
            return null;
        }
        if (fieldName.length() <= 1) {
            return fieldName;
        }
        return fieldName.substring(0, 1).toLowerCase() + fieldName.substring(1, fieldName.length());
    }

    private static String getAnnotationValue(Annotation[] annos) {
        String result = "";
        try {
            for (Annotation anno : annos) {
                Object val;
                String methodName;
                Method[] ms;
                String simpleName = anno.annotationType().getSimpleName();
                if ("JNTable".equals(simpleName)) {
                    for (Method method : ms = anno.annotationType().getDeclaredMethods()) {
                        methodName = method.getName();
                        if (!"name".equals(methodName)) continue;
                        val = method.invoke((Object)anno, null);
                        result = val + "";
                    }
                    continue;
                }
                if ("Table".equals(simpleName)) {
                    if (!"".equals(result)) continue;
                    for (Method method : ms = anno.annotationType().getDeclaredMethods()) {
                        methodName = method.getName();
                        if (!"name".equals(methodName)) continue;
                        val = method.invoke((Object)anno, null);
                        result = val + "";
                    }
                    continue;
                }
                if ("JNField".equals(simpleName)) {
                    for (Method method : ms = anno.annotationType().getDeclaredMethods()) {
                        methodName = method.getName();
                        if (!"name".equals(methodName)) continue;
                        val = method.invoke((Object)anno, null);
                        result = val + "";
                    }
                    continue;
                }
                if (!"Column".equals(simpleName) || !"".equals(result)) continue;
                for (Method method : ms = anno.annotationType().getDeclaredMethods()) {
                    methodName = method.getName();
                    if (!"name".equals(methodName)) continue;
                    val = method.invoke((Object)anno, null);
                    result = val + "";
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    private static String turnToTable(String fieldName, Annotation[] annos) {
        String str = MyBeanUtils.getAnnotationValue(annos);
        if (!"".equals(str.trim())) {
            return str;
        }
        if (fieldName == null) {
            return "";
        }
        String temp = fieldName.toLowerCase();
        char[] tmp1 = fieldName.toCharArray();
        char[] tmp2 = temp.toCharArray();
        for (int i = 0; i < tmp2.length; ++i) {
            if (i == 0) {
                str = str + tmp2[i] + "";
                if (tmp1[0] == tmp2[0] || tmp1[1] == tmp2[1]) continue;
                return fieldName;
            }
            if (tmp1[i] != tmp2[i]) {
                if (i < tmp2.length - 1 && tmp1[i + 1] != tmp2[i + 1]) {
                    return fieldName;
                }
                str = str + "_" + tmp2[i];
                continue;
            }
            str = str + tmp2[i] + "";
        }
        return str;
    }

    private static class Struct {
        private Class<?> cls;
        private Object value;
        private String alias;

        public Struct(Class<?> cls, Object value, String alias) {
            this.cls = cls;
            this.value = value;
            this.alias = alias;
        }

        public Class<?> getType() {
            return this.cls;
        }

        public Object getValue() {
            return this.value;
        }

        public String getAlias() {
            return this.alias;
        }

        public String getString(String name) {
            return this.cls + " " + name + " : " + this.value;
        }
    }
}

