/*
 * Decompiled with CFR 0.152.
 */
package com.kmall.common.utils;

import com.kmall.common.utils.DealMapValueHelper;
import com.kmall.common.utils.StringUtils;
import java.beans.PropertyDescriptor;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.beanutils.PropertyUtilsBean;
import org.apache.commons.lang.ArrayUtils;
import org.springframework.util.Assert;

public class MapUtils {
    public static String getString(String key, Map<String, Object> map) {
        if (map == null || key == null) {
            throw new IllegalArgumentException();
        }
        if (!map.containsKey(key)) {
            return null;
        }
        Object value = map.get(key);
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    public static Integer getInteger(String key, Map<String, Object> map) {
        if (map == null || key == null) {
            throw new IllegalArgumentException();
        }
        if (!map.containsKey(key)) {
            return null;
        }
        Object value = map.get(key);
        if (value == null) {
            return null;
        }
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof String) {
            return Integer.valueOf((String)value);
        }
        if (value instanceof Date) {
            throw new ClassCastException();
        }
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        throw new ClassCastException();
    }

    public static Long getLong(String key, Map<String, Object> map) {
        if (map == null || key == null) {
            throw new IllegalArgumentException();
        }
        if (!map.containsKey(key)) {
            return null;
        }
        Object value = map.get(key);
        if (value == null) {
            return null;
        }
        if (value instanceof Long) {
            return (Long)value;
        }
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        if (value instanceof String) {
            return Long.valueOf((String)value);
        }
        if (value instanceof Date) {
            return ((Date)value).getTime();
        }
        if (value instanceof Time) {
            return ((Time)value).getTime();
        }
        if (value instanceof Timestamp) {
            return ((Timestamp)value).getTime();
        }
        throw new ClassCastException();
    }

    public static Double getDouble(String key, Map<String, Object> map) {
        if (map == null || key == null) {
            throw new IllegalArgumentException();
        }
        if (!map.containsKey(key)) {
            return null;
        }
        Object value = map.get(key);
        if (value == null) {
            return null;
        }
        if (value instanceof Double) {
            return (Double)value;
        }
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        if (value instanceof String) {
            return Double.valueOf((String)value);
        }
        throw new ClassCastException();
    }

    public static BigDecimal getBigDecimal(String key, Map<String, Object> map) {
        if (map == null || key == null) {
            throw new IllegalArgumentException();
        }
        if (!map.containsKey(key)) {
            return null;
        }
        Object value = map.get(key);
        if (value == null) {
            return null;
        }
        if (value instanceof BigDecimal) {
            return (BigDecimal)value;
        }
        if (value instanceof Integer) {
            return new BigDecimal((Integer)value);
        }
        if (value instanceof Short) {
            return new BigDecimal(((Short)value).shortValue());
        }
        if (value instanceof Byte) {
            return new BigDecimal(((Byte)value).byteValue());
        }
        if (value instanceof Long) {
            return new BigDecimal((Long)value);
        }
        if (value instanceof Float) {
            return new BigDecimal(((Float)value).floatValue());
        }
        if (value instanceof Double) {
            return new BigDecimal((Double)value);
        }
        if (value instanceof Date) {
            return new BigDecimal(((Date)value).getTime());
        }
        if (value instanceof Time) {
            return new BigDecimal(((Time)value).getTime());
        }
        if (value instanceof Timestamp) {
            return new BigDecimal(((Timestamp)value).getTime());
        }
        if (value instanceof String) {
            if (!StringUtils.isNullOrEmpty((String)value)) {
                return new BigDecimal((String)value);
            }
            return null;
        }
        throw new ClassCastException();
    }

    public static Map<String, Object> getMap(Object bean) {
        return MapUtils.beanToMap(bean);
    }

    public static void toLikeValue(Map<String, Object> map, String ... likeKey) {
        if (ArrayUtils.isEmpty((Object[])likeKey)) {
            return;
        }
        for (String key : likeKey) {
            if (!map.containsKey(key)) continue;
            map.put(key, "%" + map.get(key) + "%");
        }
    }

    public static Date getDate(String key, Map<String, Object> map) {
        if (map == null || key == null) {
            throw new IllegalArgumentException();
        }
        if (!map.containsKey(key)) {
            return null;
        }
        Object value = map.get(key);
        if (value == null) {
            return null;
        }
        if (value instanceof Date) {
            return (Date)value;
        }
        if (value instanceof Timestamp) {
            return new Date(((Timestamp)value).getTime());
        }
        return null;
    }

    public static java.util.Date getTimestamp(String key, Map<String, Object> map) {
        if (map == null || key == null) {
            throw new IllegalArgumentException();
        }
        if (!map.containsKey(key)) {
            return null;
        }
        Object value = map.get(key);
        if (value == null) {
            return null;
        }
        if (value instanceof Date) {
            return (Date)value;
        }
        if (value instanceof Timestamp) {
            Timestamp ts = (Timestamp)value;
            return ts;
        }
        return null;
    }

    public static void putIfValueNotNull(Map<String, Object> map, String key, Object value) {
        Assert.notNull(map);
        Assert.hasText((String)key);
        if (value != null) {
            map.put(key, value);
        }
    }

    public static void putIfValueNotEmpty(Map<String, Object> map, String key, String value) {
        Assert.notNull(map);
        Assert.hasText((String)key);
        if (!StringUtils.isNullOrEmpty(value)) {
            map.put(key, value);
        }
    }

    public static void convertMapValuePattern(String key, Map<String, Object> map, DealMapValueHelper helper) {
        Assert.hasText((String)key);
        Assert.notNull(map);
        Assert.notNull((Object)helper);
        helper.dealValue(key, map);
    }

    public static Map<String, Object> beanToMap(Object beanObj) {
        HashMap<String, Object> params = new HashMap<String, Object>(0);
        try {
            PropertyUtilsBean propertyUtilsBean = new PropertyUtilsBean();
            PropertyDescriptor[] descriptors = propertyUtilsBean.getPropertyDescriptors(beanObj);
            for (int i = 0; i < descriptors.length; ++i) {
                String name = descriptors[i].getName();
                if ("class".equals(name)) continue;
                params.put(name, propertyUtilsBean.getNestedProperty(beanObj, name));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return params;
    }

    public static String convertMap2Xml(Map<Object, Object> paraMap) {
        StringBuffer xmlStr = new StringBuffer();
        if (paraMap != null) {
            xmlStr.append("<xml>");
            Set<Object> keySet = paraMap.keySet();
            for (String string : keySet) {
                String val = String.valueOf(paraMap.get(string));
                xmlStr.append("<");
                xmlStr.append(string);
                xmlStr.append(">");
                xmlStr.append(val);
                xmlStr.append("</");
                xmlStr.append(string);
                xmlStr.append(">");
            }
            xmlStr.append("</xml>");
        }
        return xmlStr.toString();
    }
}

