/*
 * Decompiled with CFR 0.152.
 */
package com.kmall.common.utils;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.beanutils.BeanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapBeanUtil {
    private static final Logger logger = LoggerFactory.getLogger(MapBeanUtil.class);

    public static <T> T toObject(Map<String, Object> map, Class<T> beanClass) throws Exception {
        if (map == null) {
            return null;
        }
        T bean = beanClass.newInstance();
        BeanUtils.populate(bean, map);
        return bean;
    }

    public static <T> Map<String, Object> fromObject(T bean) {
        if (bean == null) {
            return null;
        }
        return MapBeanUtil.fromObjectByIntrospector(bean);
    }

    public static <T> T toObjectByIntrospector(Map<String, Object> map, Class<T> beanClass) {
        if (map == null) {
            return null;
        }
        Object obj = null;
        try {
            PropertyDescriptor[] propertyDescriptors;
            obj = beanClass.newInstance();
            BeanInfo beanInfo = Introspector.getBeanInfo(obj.getClass());
            for (PropertyDescriptor property : propertyDescriptors = beanInfo.getPropertyDescriptors()) {
                Method setter = property.getWriteMethod();
                if (setter == null) continue;
                setter.invoke(obj, map.get(property.getName()));
            }
        }
        catch (InstantiationException e) {
            String info = "[toObjectByIntrospector] InstantiationException::Map\u8f6c\u6362Bean\u5931\u8d25";
            logger.error(info);
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            String info = "[toObjectByIntrospector] IllegalAccessException::Map\u8f6c\u6362Bean\u5931\u8d25";
            logger.error(info);
            e.printStackTrace();
        }
        catch (IntrospectionException e) {
            String info = "[toObjectByIntrospector] IntrospectionException::Map\u8f6c\u6362Bean\u5931\u8d25";
            logger.error(info);
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            String info = "[toObjectByIntrospector] InvocationTargetException::Map\u8f6c\u6362Bean\u5931\u8d25";
            logger.error(info);
            e.printStackTrace();
        }
        return (T)obj;
    }

    public static <T> Map<String, Object> fromObjectByIntrospector(T obj) {
        if (obj == null) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            PropertyDescriptor[] propertyDescriptors;
            BeanInfo beanInfo = Introspector.getBeanInfo(obj.getClass());
            for (PropertyDescriptor property : propertyDescriptors = beanInfo.getPropertyDescriptors()) {
                String key = property.getName();
                if (key.compareToIgnoreCase("class") == 0) continue;
                Method getter = property.getReadMethod();
                Object value = getter != null ? getter.invoke(obj, new Object[0]) : null;
                map.put(key, value);
            }
        }
        catch (IntrospectionException e) {
            String info = "[fromObjectByIntrospector] IntrospectionException::Bean\u8f6c\u6362Map\u5931\u8d25";
            logger.error(info);
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            String info = "[fromObjectByIntrospector] InvocationTargetException::Bean\u8f6c\u6362Map\u5931\u8d25";
            logger.error(info);
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            String info = "[fromObjectByIntrospector] IllegalArgumentException::Bean\u8f6c\u6362Map\u5931\u8d25,";
            logger.error(info);
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            String info = "[fromObjectByIntrospector] IllegalAccessException::Bean\u8f6c\u6362Map\u5931\u8d25";
            logger.error(info);
            e.printStackTrace();
        }
        return map;
    }

    public static <T> T toObjectByReflect(Map<String, Object> map, Class<T> beanClass) {
        if (map == null) {
            return null;
        }
        Object obj = null;
        try {
            Field[] fields;
            obj = beanClass.newInstance();
            for (Field field : fields = obj.getClass().getDeclaredFields()) {
                int mod = field.getModifiers();
                if (Modifier.isStatic(mod) || Modifier.isFinal(mod)) continue;
                field.setAccessible(true);
                field.set(obj, map.get(field.getName()));
            }
        }
        catch (InstantiationException e) {
            String info = "[toObjectByReflect] InstantiationException::Map\u8f6c\u6362Bean\u5931\u8d25";
            logger.error(info);
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            String info = "[toObjectByReflect] IllegalAccessException::Map\u8f6c\u6362Bean\u5931\u8d25";
            logger.error(info);
            e.printStackTrace();
        }
        return (T)obj;
    }

    public static <T> Map<String, Object> fromObjectByReflect(T obj) {
        if (obj == null) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            Field[] declaredFields;
            for (Field field : declaredFields = obj.getClass().getDeclaredFields()) {
                field.setAccessible(true);
                map.put(field.getName(), field.get(obj));
            }
        }
        catch (IllegalAccessException e) {
            String info = "[fromObjectByReflect] IllegalAccessException::Bean\u8f6c\u6362Map\u5931\u8d25";
            logger.error(info);
            e.printStackTrace();
        }
        return map;
    }
}

