/*
 * Decompiled with CFR 0.152.
 */
package com.kmall.common.utils;

import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MD5Sign {
    private static final Logger logger = LoggerFactory.getLogger(MD5Sign.class);
    private static String INPUT_CHARSET_UTF8 = "UTF-8";

    public static Map<String, Object> sortMapByKey(Map<String, Object> params) {
        if (params == null || params.isEmpty()) {
            return null;
        }
        TreeMap<String, Object> sortMap = new TreeMap<String, Object>((x, y) -> x.compareTo((String)y));
        sortMap.putAll(params);
        return sortMap;
    }

    public static String buildParamsStr(Map<String, Object> params) {
        if (params == null || params.isEmpty()) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            sb.append(String.valueOf(entry.getKey()) + String.valueOf(entry.getValue()));
        }
        return sb.toString();
    }

    public static String insertSecretKey(String text, String secretKey) {
        return new StringBuffer(text).insert(0, secretKey).toString();
    }

    public static String sign(Map<String, Object> params, String secretKey) {
        String paramsStr = MD5Sign.insertSecretKey(MD5Sign.buildParamsStr(MD5Sign.sortMapByKey(params)), secretKey);
        String signature = DigestUtils.md5Hex((byte[])MD5Sign.getContentBytes(paramsStr, INPUT_CHARSET_UTF8));
        logger.debug("\u52a0\u7b7e: {}", (Object)signature);
        return signature;
    }

    public static boolean verify(String signature, Map<String, Object> params, String secretKey) {
        String paramsStr = MD5Sign.insertSecretKey(MD5Sign.buildParamsStr(MD5Sign.sortMapByKey(params)), secretKey);
        String calculateSign = DigestUtils.md5Hex((byte[])MD5Sign.getContentBytes(paramsStr, INPUT_CHARSET_UTF8));
        boolean verify = calculateSign.equals(signature);
        logger.debug("\u7cfb\u7edf\u751f\u6210\u7684\u7b7e\u540d\uff1a:{}", (Object)calculateSign);
        logger.debug("\u9a8c\u7b7e: {}", (Object)signature);
        logger.debug("\u9a8c\u7b7e\u7ed3\u679c: {}", (Object)verify);
        return verify;
    }

    private static byte[] getContentBytes(String content, String charset) {
        if (charset == null || "".equals(charset)) {
            return content.getBytes();
        }
        try {
            return content.getBytes(charset);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("MD5\u7b7e\u540d\u8fc7\u7a0b\u4e2d\u51fa\u73b0\u9519\u8bef,\u6307\u5b9a\u7684\u7f16\u7801\u96c6\u4e0d\u5bf9,\u60a8\u76ee\u524d\u6307\u5b9a\u7684\u7f16\u7801\u96c6\u662f:" + charset);
        }
    }

    public static void main(String[] args) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        String data = "{\"idCard\":\"430527199312244222\",\"name\":\"\u9ec4\u4e9a\u7434\",\"videoBase64\":\"111\",\"livenessType\":\"SILENT\",\"merchId\":\"mhbs990053989883052032\",\"merchName\":\"\u4e2d\u7f51\u79d1\u6280\",\"platSn\":\"mhpt990060576152485888\"}";
        map.put("data", data);
        map.put("timestamp", "1574240977");
        map.put("merchId", "mhbs990053989883052032");
        String si = MD5Sign.sign(map, "IxyIvP0sJqlUZinx");
        MD5Sign.verify(si, map, "IxyIvP0sJqlUZinx");
    }
}

