/*
 * Decompiled with CFR 0.152.
 */
package com.kmall.common.utils;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.kmall.common.utils.JacksonStringUnicodeSerializer;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JacksonUtils {
    private static final Logger logger = LoggerFactory.getLogger(JacksonUtils.class);
    private static ObjectMapper objectMapper;
    private static final ThreadLocal<JacksonUtils> jacksonUtilThreadLocal;
    private static final ThreadLocal<ObjectMapper> objectMapperThreadLocal;

    private JacksonUtils() {
    }

    public static JacksonUtils instance() {
        JacksonUtils jacksonUtils = jacksonUtilThreadLocal.get();
        if (jacksonUtils == null) {
            jacksonUtils = new JacksonUtils();
            jacksonUtilThreadLocal.set(jacksonUtils);
        }
        return jacksonUtils;
    }

    public static ObjectMapper objectMapper() {
        objectMapper = objectMapperThreadLocal.get();
        if (objectMapper == null) {
            objectMapper = new ObjectMapper();
            objectMapper.setLocale(Locale.SIMPLIFIED_CHINESE);
            objectMapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
            objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            objectMapper.configure(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT, true);
            objectMapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_CONTROL_CHARS, true);
            objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
            objectMapperThreadLocal.set(objectMapper);
        }
        return objectMapper;
    }

    private static SimpleModule unicodeSerModule() {
        SimpleModule unicodeSerModule = new SimpleModule();
        unicodeSerModule.addSerializer(String.class, (JsonSerializer)new JacksonStringUnicodeSerializer());
        return unicodeSerModule;
    }

    private static JsonParser getParser(String content) {
        try {
            return JacksonUtils.objectMapper().getFactory().createParser(content);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return null;
        }
    }

    private static JsonParser getByteParser(byte[] data) {
        try {
            return JacksonUtils.objectMapper().getFactory().createParser(data);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return null;
        }
    }

    private static JsonParser getReaderParser(Reader r) {
        try {
            return JacksonUtils.objectMapper().getFactory().createParser(r);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return null;
        }
    }

    private static JsonParser getReaderParser(InputStream in) {
        try {
            return JacksonUtils.objectMapper().getFactory().createParser(in);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return null;
        }
    }

    private static JsonGenerator getGenerator(StringWriter sw) {
        try {
            return JacksonUtils.objectMapper().getFactory().createGenerator((Writer)sw);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return null;
        }
    }

    public static <T> String toJson(T obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof String) {
            return (String)obj;
        }
        StringWriter sw = new StringWriter();
        JsonGenerator jsonGen = JacksonUtils.getGenerator(sw);
        if (jsonGen == null) {
            try {
                sw.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return null;
        }
        try {
            jsonGen.writeObject(obj);
            jsonGen.flush();
            jsonGen.close();
            return sw.toString();
        }
        catch (JsonGenerationException jge) {
            logger.error("toJSON\u5e8f\u5217\u5316\u5931\u8d25, \u5f02\u5e38\u7c7b\u578b\u3010JsonGenerationException\u3011,\u9519\u8bef\u539f\u56e0:{}", (Object)jge.getMessage());
        }
        catch (IOException ioe) {
            logger.error("toJSON\u5e8f\u5217\u5316\u5931\u8d25, \u5f02\u5e38\u7c7b\u578b\u3010IOException\u3011, \u9519\u8bef\u539f\u56e0:{}", (Object)ioe.getMessage());
            ioe.printStackTrace();
        }
        return null;
    }

    public static <T> String toJsonWithPretty(T obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof String) {
            return (String)obj;
        }
        StringWriter sw = new StringWriter();
        JsonGenerator jsonGen = JacksonUtils.getGenerator(sw);
        if (jsonGen == null) {
            try {
                sw.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return null;
        }
        try {
            jsonGen.useDefaultPrettyPrinter().writeObject(obj);
            jsonGen.flush();
            jsonGen.close();
            return sw.toString();
        }
        catch (Exception e) {
            System.out.println("Parse object to String error");
            e.printStackTrace();
            return null;
        }
    }

    public static <T> T fromByteJson(byte[] data, Class<T> clazz) {
        try {
            JsonParser jp = JacksonUtils.getByteParser(data);
            return (T)jp.readValueAs(clazz);
        }
        catch (JsonParseException e) {
            logger.error(String.format("fromByteJson\u53cd\u5e8f\u5217\u5316\u5931\u8d25, \u5f02\u5e38\u7c7b\u578b\u3010JsonParseException\u3011, \u9519\u8bef\u539f\u56e0:{}", e.getMessage()));
        }
        catch (JsonMappingException e) {
            logger.error(String.format("fromByteJson\u53cd\u5e8f\u5217\u5316\u5931\u8d25, \u5f02\u5e38\u7c7b\u578b\u3010JsonMappingException\u3011, \u9519\u8bef\u539f\u56e0:{}", e.getMessage()));
        }
        catch (IOException e) {
            logger.error(String.format("fromByteJson\u53cd\u5e8f\u5217\u5316\u5931\u8d25, \u5f02\u5e38\u7c7b\u578b\u3010IOException\u3011, \u9519\u8bef\u539f\u56e0:{}", e.getMessage()));
        }
        return null;
    }

    public static <T> T fromStringJson(String json, Class<T> clazz) {
        try {
            return (T)(clazz.equals(String.class) ? json : JacksonUtils.getParser(json).readValueAs(clazz));
        }
        catch (JsonParseException e) {
            logger.error(String.format("fromStringJson\u53cd\u5e8f\u5217\u5316\u5931\u8d25, \u5f02\u5e38\u7c7b\u578b\u3010JsonParseException\u3011, \u9519\u8bef\u539f\u56e0:{}", e.getMessage()));
            logger.error("decode(String, Class<T>)", (Throwable)e);
        }
        catch (JsonMappingException e) {
            logger.error(String.format("fromStringJson\u53cd\u5e8f\u5217\u5316\u5931\u8d25, \u5f02\u5e38\u7c7b\u578b\u3010JsonMappingException\u3011, \u9519\u8bef\u539f\u56e0:{}", e.getMessage()));
            logger.error("decode(String, Class<T>)", (Throwable)e);
        }
        catch (IOException e) {
            logger.error(String.format("fromStringJson\u53cd\u5e8f\u5217\u5316\u5931\u8d25, \u5f02\u5e38\u7c7b\u578b\u3010IOException\u3011, \u9519\u8bef\u539f\u56e0:{}", e.getMessage()));
            logger.error("decode(String, Class<T>)", (Throwable)e);
        }
        return null;
    }

    public static <T> T fromStringJson(String json, TypeReference<T> typeReference) {
        try {
            JsonParser jp = JacksonUtils.getParser(json);
            return (T)(typeReference.getType().equals(String.class) ? json : jp.readValueAs(typeReference));
        }
        catch (JsonParseException e) {
            logger.error(String.format("fromListJson\u53cd\u5e8f\u5217\u5316\u5931\u8d25, \u5f02\u5e38\u7c7b\u578b\u3010JsonParseException\u3011, \u9519\u8bef\u539f\u56e0:{}", e.getMessage()));
            logger.error("decode(String, Class<T>)", (Throwable)e);
        }
        catch (JsonMappingException e) {
            logger.error(String.format("fromListJson\u53cd\u5e8f\u5217\u5316\u5931\u8d25, \u5f02\u5e38\u7c7b\u578b\u3010JsonMappingException\u3011, \u9519\u8bef\u539f\u56e0:{}", e.getMessage()));
            logger.error("decode(String, Class<T>)", (Throwable)e);
        }
        catch (IOException e) {
            logger.error(String.format("fromListJson\u53cd\u5e8f\u5217\u5316\u5931\u8d25, \u5f02\u5e38\u7c7b\u578b\u3010IOException\u3011, \u9519\u8bef\u539f\u56e0:{}", e.getMessage()));
            logger.error("decode(String, Class<T>)", (Throwable)e);
        }
        return null;
    }

    public static <T> T fromStringJson(String json, Class<?> collectionClass, Class<?> ... elementClasses) {
        JavaType javaType = JacksonUtils.objectMapper().getTypeFactory().constructParametricType(collectionClass, (Class[])elementClasses);
        try {
            return (T)JacksonUtils.objectMapper().readValue(json, javaType);
        }
        catch (IOException e) {
            logger.error("Parse String to Object error");
            e.printStackTrace();
            return null;
        }
    }

    static {
        jacksonUtilThreadLocal = new ThreadLocal();
        objectMapperThreadLocal = new ThreadLocal();
    }
}

