/*
 * Decompiled with CFR 0.152.
 */
package com.kmall.common.utils;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.io.CharTypes;
import com.fasterxml.jackson.core.json.JsonWriteContext;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;

public class JacksonStringUnicodeSerializer
extends JsonSerializer<String> {
    private final char[] HEX_CHARS = "0123456789ABCDEF".toCharArray();
    private final int[] ESCAPE_CODES = CharTypes.get7BitOutputEscapes();

    private void writeUnicodeEscape(JsonGenerator gen, char c) throws IOException {
        gen.writeRaw('\\');
        gen.writeRaw('u');
        gen.writeRaw(this.HEX_CHARS[c >> 12 & 0xF]);
        gen.writeRaw(this.HEX_CHARS[c >> 8 & 0xF]);
        gen.writeRaw(this.HEX_CHARS[c >> 4 & 0xF]);
        gen.writeRaw(this.HEX_CHARS[c & 0xF]);
    }

    private void writeShortEscape(JsonGenerator gen, char c) throws IOException {
        gen.writeRaw('\\');
        gen.writeRaw(c);
    }

    public void serialize(String str, JsonGenerator gen, SerializerProvider provider) throws IOException, JsonProcessingException {
        int status2 = ((JsonWriteContext)gen.getOutputContext()).writeValue();
        switch (status2) {
            case 2: {
                gen.writeRaw(':');
                break;
            }
            case 1: {
                gen.writeRaw(',');
                break;
            }
            case 5: {
                throw new JsonParseException("Can not write string value here", null);
            }
        }
        gen.writeRaw('\"');
        for (char c : str.toCharArray()) {
            int code;
            if (c >= '\u0080') {
                this.writeUnicodeEscape(gen, c);
                continue;
            }
            int n = code = c < this.ESCAPE_CODES.length ? this.ESCAPE_CODES[c] : 0;
            if (code == 0) {
                gen.writeRaw(c);
                continue;
            }
            if (code < 0) {
                this.writeUnicodeEscape(gen, (char)(-code - 1));
                continue;
            }
            this.writeShortEscape(gen, (char)code);
        }
        gen.writeRaw('\"');
    }
}

