/*
 * Decompiled with CFR 0.152.
 */
package com.kmall.common.utils;

import com.alibaba.fastjson.JSON;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Map;
import java.util.Set;
import org.apache.commons.httpclient.Cookie;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.cookie.CookiePolicy;
import org.apache.commons.httpclient.cookie.CookieSpec;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HttpUtil {
    private static final Log logger = LogFactory.getLog(HttpUtil.class);
    public static final String URL_PARAM_DECODECHARSET_UTF8 = "UTF-8";
    public static final String URL_PARAM_DECODECHARSET_GBK = "GBK";
    private static final String URL_PARAM_CONNECT_FLAG = "&";
    private static final String EMPTY = "";
    private static MultiThreadedHttpConnectionManager connectionManager = null;
    private static int connectionTimeOut = 25000;
    private static int socketTimeOut = 25000;
    private static int maxConnectionPerHost = 20;
    private static int maxTotalConnections = 20;
    private static HttpClient client;
    static Cookie[] cookies;
    static String loginURL;
    static String loginUserName;
    static String loginPassword;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String URLPost(String url, Map<String, Object> params, String enc) {
        String response = EMPTY;
        PostMethod postMethod = null;
        try {
            postMethod = new PostMethod(url);
            postMethod.setRequestHeader("Content-Type", "application/x-www-form-urlencoded;charset=" + enc);
            Set<String> keySet = params.keySet();
            for (String key : keySet) {
                Object value = params.get(key);
                postMethod.addParameter(key, String.valueOf(value));
            }
            int statusCode = client.executeMethod((HttpMethod)postMethod);
            if (statusCode == 200) {
                response = postMethod.getResponseBodyAsString();
            } else {
                logger.error((Object)("\u54cd\u5e94\u72b6\u6001\u7801 = " + postMethod.getStatusCode()));
            }
        }
        catch (HttpException e) {
            logger.error((Object)"\u53d1\u751f\u81f4\u547d\u7684\u5f02\u5e38\uff0c\u53ef\u80fd\u662f\u534f\u8bae\u4e0d\u5bf9\u6216\u8005\u8fd4\u56de\u7684\u5185\u5bb9\u6709\u95ee\u9898", (Throwable)e);
            e.printStackTrace();
        }
        catch (IOException e) {
            logger.error((Object)"\u53d1\u751f\u7f51\u7edc\u5f02\u5e38", (Throwable)e);
            e.printStackTrace();
        }
        finally {
            if (postMethod != null) {
                postMethod.releaseConnection();
                postMethod = null;
            }
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String URLPost(String url, Map<String, Object> header, Map<String, Object> params, String enc) {
        String response = EMPTY;
        PostMethod postMethod = null;
        try {
            postMethod = new PostMethod(url);
            postMethod.setRequestHeader("Content-Type", "application/x-www-form-urlencoded;charset=" + enc);
            if (null != header && header.size() > 0) {
                for (Map.Entry<String, Object> entry : header.entrySet()) {
                    postMethod.setRequestHeader(entry.getKey(), String.valueOf(entry.getValue()));
                }
            }
            Set<String> keySet = params.keySet();
            for (String key : keySet) {
                Object value = params.get(key);
                postMethod.addParameter(key, String.valueOf(value));
            }
            int n = client.executeMethod((HttpMethod)postMethod);
            if (n == 200) {
                response = postMethod.getResponseBodyAsString();
            } else {
                logger.error((Object)("\u54cd\u5e94\u72b6\u6001\u7801 = " + postMethod.getStatusCode()));
            }
        }
        catch (HttpException e) {
            logger.error((Object)"\u53d1\u751f\u81f4\u547d\u7684\u5f02\u5e38\uff0c\u53ef\u80fd\u662f\u534f\u8bae\u4e0d\u5bf9\u6216\u8005\u8fd4\u56de\u7684\u5185\u5bb9\u6709\u95ee\u9898", (Throwable)e);
            e.printStackTrace();
        }
        catch (IOException e) {
            logger.error((Object)"\u53d1\u751f\u7f51\u7edc\u5f02\u5e38", (Throwable)e);
            e.printStackTrace();
        }
        finally {
            if (postMethod != null) {
                postMethod.releaseConnection();
                postMethod = null;
            }
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String URLPostByJsonData(String url, Map<String, Object> header, Map<String, Object> params, String enc) {
        String response = EMPTY;
        PostMethod postMethod = null;
        try {
            postMethod = new PostMethod(url);
            postMethod.setRequestHeader("Content-Type", "application/json;charset=" + enc);
            if (null != header && header.size() > 0) {
                for (Map.Entry<String, Object> entry : header.entrySet()) {
                    postMethod.setRequestHeader(entry.getKey(), String.valueOf(entry.getValue()));
                }
            }
            StringRequestEntity entity = new StringRequestEntity(JSON.toJSONString(params), "application/json", URL_PARAM_DECODECHARSET_UTF8);
            postMethod.setRequestEntity((RequestEntity)entity);
            int statusCode = client.executeMethod((HttpMethod)postMethod);
            if (statusCode == 200) {
                response = postMethod.getResponseBodyAsString();
            } else {
                logger.error((Object)("\u54cd\u5e94\u72b6\u6001\u7801 = " + postMethod.getStatusCode()));
            }
        }
        catch (HttpException e) {
            logger.error((Object)"\u53d1\u751f\u81f4\u547d\u7684\u5f02\u5e38\uff0c\u53ef\u80fd\u662f\u534f\u8bae\u4e0d\u5bf9\u6216\u8005\u8fd4\u56de\u7684\u5185\u5bb9\u6709\u95ee\u9898", (Throwable)e);
            e.printStackTrace();
        }
        catch (IOException e) {
            logger.error((Object)"\u53d1\u751f\u7f51\u7edc\u5f02\u5e38", (Throwable)e);
            e.printStackTrace();
        }
        finally {
            if (postMethod != null) {
                postMethod.releaseConnection();
                postMethod = null;
            }
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String URLGet(String url, Map<String, Object> params, String enc) {
        String response = EMPTY;
        GetMethod getMethod = null;
        StringBuffer strtTotalURL = new StringBuffer(EMPTY);
        if (strtTotalURL.indexOf("?") == -1) {
            strtTotalURL.append(url).append("?").append(HttpUtil.getUrl(params, enc));
        } else {
            strtTotalURL.append(url).append(URL_PARAM_CONNECT_FLAG).append(HttpUtil.getUrl(params, enc));
        }
        logger.debug((Object)("GET\u8bf7\u6c42URL = \n" + strtTotalURL.toString()));
        try {
            getMethod = new GetMethod(strtTotalURL.toString());
            getMethod.setRequestHeader("Content-Type", "application/x-www-form-urlencoded;charset=" + enc);
            int statusCode = client.executeMethod((HttpMethod)getMethod);
            if (statusCode == 200) {
                response = getMethod.getResponseBodyAsString();
            } else {
                logger.debug((Object)("\u54cd\u5e94\u72b6\u6001\u7801 = " + getMethod.getStatusCode()));
            }
        }
        catch (HttpException e) {
            logger.error((Object)"\u53d1\u751f\u81f4\u547d\u7684\u5f02\u5e38\uff0c\u53ef\u80fd\u662f\u534f\u8bae\u4e0d\u5bf9\u6216\u8005\u8fd4\u56de\u7684\u5185\u5bb9\u6709\u95ee\u9898", (Throwable)e);
            e.printStackTrace();
        }
        catch (IOException e) {
            logger.error((Object)"\u53d1\u751f\u7f51\u7edc\u5f02\u5e38", (Throwable)e);
            e.printStackTrace();
        }
        finally {
            if (getMethod != null) {
                getMethod.releaseConnection();
                getMethod = null;
            }
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String URLGet(String url, Map<String, Object> header, Map<String, Object> params, String enc) {
        String response = EMPTY;
        GetMethod getMethod = null;
        StringBuffer strtTotalURL = new StringBuffer(EMPTY);
        if (strtTotalURL.indexOf("?") == -1) {
            strtTotalURL.append(url).append("?").append(HttpUtil.getUrl(params, enc));
        } else {
            strtTotalURL.append(url).append(URL_PARAM_CONNECT_FLAG).append(HttpUtil.getUrl(params, enc));
        }
        logger.debug((Object)("GET\u8bf7\u6c42URL = \n" + strtTotalURL.toString()));
        try {
            int statusCode;
            getMethod = new GetMethod(strtTotalURL.toString());
            getMethod.setRequestHeader("Content-Type", "application/x-www-form-urlencoded;charset=" + enc);
            if (null != header && header.size() > 0) {
                for (Map.Entry<String, Object> entry : header.entrySet()) {
                    getMethod.setRequestHeader(entry.getKey(), String.valueOf(entry.getValue()));
                }
            }
            if ((statusCode = client.executeMethod((HttpMethod)getMethod)) == 200) {
                response = getMethod.getResponseBodyAsString();
            } else {
                logger.debug((Object)("\u54cd\u5e94\u72b6\u6001\u7801 = " + getMethod.getStatusCode()));
            }
        }
        catch (HttpException e) {
            logger.error((Object)"\u53d1\u751f\u81f4\u547d\u7684\u5f02\u5e38\uff0c\u53ef\u80fd\u662f\u534f\u8bae\u4e0d\u5bf9\u6216\u8005\u8fd4\u56de\u7684\u5185\u5bb9\u6709\u95ee\u9898", (Throwable)e);
            e.printStackTrace();
        }
        catch (IOException e) {
            logger.error((Object)"\u53d1\u751f\u7f51\u7edc\u5f02\u5e38", (Throwable)e);
            e.printStackTrace();
        }
        finally {
            if (getMethod != null) {
                getMethod.releaseConnection();
                getMethod = null;
            }
        }
        return response;
    }

    private static String getUrl(Map<String, Object> map, String valueEnc) {
        if (null == map || map.keySet().size() == 0) {
            return EMPTY;
        }
        StringBuffer url = new StringBuffer();
        Set<String> keys = map.keySet();
        for (String key : keys) {
            if (!map.containsKey(key)) continue;
            String val = map.get(key).toString();
            String str = val != null ? val : EMPTY;
            try {
                str = URLEncoder.encode(str, valueEnc);
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            url.append(key).append("=").append(str).append(URL_PARAM_CONNECT_FLAG);
        }
        String strURL = EMPTY;
        strURL = url.toString();
        if (URL_PARAM_CONNECT_FLAG.equals(EMPTY + strURL.charAt(strURL.length() - 1))) {
            strURL = strURL.substring(0, strURL.length() - 1);
        }
        return strURL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String URLPost(String url, Map<String, Object> params, String enc, boolean session) {
        String response = EMPTY;
        PostMethod postMethod = null;
        if (!session) {
            return HttpUtil.URLPost(url, params, enc);
        }
        try {
            postMethod = new PostMethod(url);
            postMethod.setRequestHeader("Content-Type", "application/x-www-form-urlencoded;charset=" + enc);
            Set<String> keySet = params.keySet();
            for (String key : keySet) {
                Object value = params.get(key);
                postMethod.addParameter(key, String.valueOf(value));
            }
            if (null != cookies) {
                client.getState().addCookies(cookies);
            } else {
                HttpUtil.getAuthCookie(url, enc);
                client.getState().addCookies(cookies);
            }
            int statusCode = client.executeMethod((HttpMethod)postMethod);
            if (statusCode == 200) {
                response = postMethod.getResponseBodyAsString();
            } else {
                logger.error((Object)("\u54cd\u5e94\u72b6\u6001\u7801 = " + postMethod.getStatusCode()));
            }
        }
        catch (HttpException e) {
            logger.error((Object)"\u53d1\u751f\u81f4\u547d\u7684\u5f02\u5e38\uff0c\u53ef\u80fd\u662f\u534f\u8bae\u4e0d\u5bf9\u6216\u8005\u8fd4\u56de\u7684\u5185\u5bb9\u6709\u95ee\u9898", (Throwable)e);
            e.printStackTrace();
        }
        catch (IOException e) {
            logger.error((Object)"\u53d1\u751f\u7f51\u7edc\u5f02\u5e38", (Throwable)e);
            e.printStackTrace();
        }
        finally {
            if (postMethod != null) {
                postMethod.releaseConnection();
                postMethod = null;
            }
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void getAuthCookie(String url, String enc) {
        PostMethod postMethod = null;
        try {
            Object[] ipPort = HttpUtil.getIpPortFormURL(url);
            String ip = (String)ipPort[0];
            int port = (Integer)ipPort[1];
            String logUrl = "http://" + ip + ":" + port + loginURL;
            postMethod = new PostMethod(logUrl);
            postMethod.addParameter("username", loginUserName);
            postMethod.addParameter("password", loginPassword);
            postMethod.setRequestHeader("Content-Type", "application/x-www-form-urlencoded;charset=" + enc);
            int statusCode = client.executeMethod((HttpMethod)postMethod);
            CookieSpec cookiespec = CookiePolicy.getDefaultSpec();
            cookies = cookiespec.match(ip, port, "/", false, client.getState().getCookies());
            logger.error((Object)("\u54cd\u5e94\u72b6\u6001\u7801 = " + postMethod.getStatusCode()));
        }
        catch (HttpException e) {
            logger.error((Object)"\u53d1\u751f\u81f4\u547d\u7684\u5f02\u5e38\uff0c\u53ef\u80fd\u662f\u534f\u8bae\u4e0d\u5bf9\u6216\u8005\u8fd4\u56de\u7684\u5185\u5bb9\u6709\u95ee\u9898", (Throwable)e);
            e.printStackTrace();
        }
        catch (IOException e) {
            logger.error((Object)"\u53d1\u751f\u7f51\u7edc\u5f02\u5e38", (Throwable)e);
            e.printStackTrace();
        }
        finally {
            if (postMethod != null) {
                postMethod.releaseConnection();
                postMethod = null;
            }
        }
    }

    public static Object[] getIpPortFormURL(String URL2) {
        Object[] ip_port = new Object[2];
        try {
            URL url = new URL(URL2);
            ip_port[0] = url.getHost();
            ip_port[1] = url.getPort() != -1 ? url.getPort() : 80;
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        return ip_port;
    }

    public static void setLoginPassword(String loginPassword) {
        HttpUtil.loginPassword = loginPassword;
    }

    public static void setLoginUserName(String loginUserName) {
        HttpUtil.loginUserName = loginUserName;
    }

    public static void setLoginURL(String loginURL) {
        HttpUtil.loginURL = loginURL;
    }

    public static void main(String[] args) throws MalformedURLException {
        URL url = new URL("http://blog.csdn.net/zhujianlin1990");
        System.out.println(url.getHost());
        System.out.println(url.getPort());
    }

    static {
        cookies = null;
        loginURL = "/admin/login.do";
        loginUserName = "admin";
        loginPassword = "admin";
        connectionManager = new MultiThreadedHttpConnectionManager();
        connectionManager.getParams().setConnectionTimeout(connectionTimeOut);
        connectionManager.getParams().setSoTimeout(socketTimeOut);
        connectionManager.getParams().setDefaultMaxConnectionsPerHost(maxConnectionPerHost);
        connectionManager.getParams().setMaxTotalConnections(maxTotalConnections);
        client = new HttpClient((HttpConnectionManager)connectionManager);
    }
}

