/*
 * Decompiled with CFR 0.152.
 */
package com.kmall.common.utils;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.StringUtils;

public class DateUtils {
    private static final Log logger = LogFactory.getLog(DateUtils.class);
    public static final String DATE_PATTERN = "yyyy-MM-dd";
    public static String DATE_TIME_PATTERN_YYYY_MM_DD = "yyyyMMdd";
    public static String DATE_TIME_PATTERN_YYYY_MM_DD_HH_MM_SS = "yyyyMMddHHmmss";
    public static String DATE_TIME_PATTERN_YYYY_MM_DD_HH_MM_SS_SSS = "yyyyMMddHHmmssSSS";
    public static String PATTERN_YYYY_MM_DD_HH_MM = "yyyy.MM.dd HH:mm";
    public static final String DATE_TIME_PATTERN = "yyyy-MM-dd HH:mm:ss";
    public static String[][] regularExp = new String[][]{{"\\d{4}-((([0][1,3-9]|[1][0-2]|[1-9])-([0-2]\\d|[3][0,1]|[1-9]))|((02|2)-(([1-9])|[0-2]\\d)))\\s+([0,1]\\d|[2][0-3]|\\d):([0-5]\\d|\\d):([0-5]\\d|\\d)", "yyyy-MM-dd HH:mm:ss"}, {"\\d{4}.((([0][1,3-9]|[1][0-2]|[1-9]).([0-2]\\d|[3][0,1]|[1-9]))|((02|2).(([1-9])|[0-2]\\d)))\\s+([0,1]\\d|[2][0-3]|\\d):([0-5]\\d|\\d)", PATTERN_YYYY_MM_DD_HH_MM}, {"\\d{4}-((([0][1,3-9]|[1][0-2]|[1-9])-([0-2]\\d|[3][0,1]|[1-9]))|((02|2)-(([1-9])|[0-2]\\d)))", "yyyy-MM-dd"}, {"\\d{4}((([0][1,3-9]|[1][0-2]|[1-9])([0-2]\\d|[3][0,1]|[1-9]))|((02|2)(([1-9])|[0-2]\\d)))([0,1]\\d|[2][0-3])([0-5]\\d|\\d)([0-5]\\d|\\d)\\d{1,3}", DATE_TIME_PATTERN_YYYY_MM_DD_HH_MM_SS_SSS}};

    public static String format(Date date) {
        return DateUtils.format(date, DATE_PATTERN);
    }

    public static String format(Date date, String pattern) {
        if (date != null) {
            SimpleDateFormat df = new SimpleDateFormat(pattern);
            return df.format(date);
        }
        return null;
    }

    public static String timeToStr(Long time, String pattern) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(pattern);
        if (time.toString().length() < 13) {
            time = time * 1000L;
        }
        Date date = new Date(time);
        String value = dateFormat.format(date);
        return value;
    }

    public static long strToTime(String timeStr) {
        Date time = DateUtils.strToDate(timeStr);
        return time.getTime() / 1000L;
    }

    public static long pastMinutes(Date date) {
        long t = new Date().getTime() - date.getTime();
        return t / 60000L;
    }

    public static Date strToDate(String strDate) {
        try {
            String strType = DateUtils.getDateFormat(strDate);
            SimpleDateFormat sf = new SimpleDateFormat(strType);
            return new Date(sf.parse(strDate).getTime());
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getDateFormat(String date_str) {
        String style = null;
        if (StringUtils.isEmpty((Object)date_str)) {
            return null;
        }
        boolean b = false;
        for (int i = 0; i < regularExp.length; ++i) {
            b = date_str.matches(regularExp[i][0]);
            if (!b) continue;
            style = regularExp[i][1];
        }
        if (StringUtils.isEmpty(style)) {
            logger.info((Object)("date_str:" + date_str));
            logger.info((Object)"\u65e5\u671f\u683c\u5f0f\u83b7\u53d6\u51fa\u9519\uff0c\u672a\u8bc6\u522b\u7684\u65e5\u671f\u683c\u5f0f");
        }
        return style;
    }

    public static Date convertStringToDate(String dateStr, String format) {
        Date resultDate = null;
        try {
            SimpleDateFormat sdf = new SimpleDateFormat(format);
            resultDate = sdf.parse(dateStr);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return resultDate;
    }

    public static Date[] getMonthStartEnd(Date time) {
        Date[] startEndDate = new Date[2];
        Calendar cal = Calendar.getInstance();
        cal.setTime(time);
        cal.set(5, 1);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        startEndDate[0] = cal.getTime();
        cal.set(5, cal.getActualMaximum(5));
        cal.set(11, 23);
        cal.set(12, 59);
        cal.set(13, 59);
        cal.set(14, 999);
        startEndDate[1] = cal.getTime();
        return startEndDate;
    }

    public static String getDate(String datdString) {
        datdString = datdString.replace("GMT", "").replaceAll("\\(.*\\)", "");
        SimpleDateFormat format = new SimpleDateFormat("EEE MMM dd yyyy HH:mm:ss z", Locale.ENGLISH);
        Date dateTrans = null;
        try {
            dateTrans = format.parse(datdString);
            return new SimpleDateFormat(DATE_PATTERN).format(dateTrans);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return datdString;
        }
    }

    public static Boolean compareDate(Date startDate, Date endDate) {
        if (startDate.compareTo(endDate) == 0) {
            return true;
        }
        if (startDate.getTime() > endDate.getTime()) {
            return false;
        }
        return true;
    }

    public static Date addDay(Date date, Integer day) {
        Date d = new Date();
        SimpleDateFormat format = new SimpleDateFormat(DATE_PATTERN);
        String currdate = format.format(d);
        Calendar ca = Calendar.getInstance();
        ca.setTime(date);
        ca.add(5, day);
        d = ca.getTime();
        String enddate = format.format(d);
        return d;
    }

    public static String addMin(Date date, Integer min) {
        SimpleDateFormat format = new SimpleDateFormat("HH:mm:ss");
        Calendar ca = Calendar.getInstance();
        ca.setTime(date);
        ca.add(12, min);
        Date d = ca.getTime();
        String enddate = format.format(d);
        return enddate;
    }

    public static void main(String[] args) {
        System.out.println(DateUtils.compareDate(new Date(), new Date()));
        System.out.println(new BigDecimal("11").compareTo(new BigDecimal("11")));
        System.out.println(BigDecimal.valueOf(Double.valueOf("0.112")));
    }
}

