/*
 * Decompiled with CFR 0.152.
 */
package com.kmall.common.utils;

import com.kmall.common.utils.RRException;
import com.kmall.common.utils.StringUtils;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.beans.FatalBeanException;
import org.springframework.util.Assert;

public class BeanUtils
extends org.springframework.beans.BeanUtils {
    private static String[] IGNORE_PROPERTIES = new String[]{"createUser", "createTime"};

    public static void copyProperties(Object source, Object target, String[] ignoreList) throws BeansException {
        PropertyDescriptor[] targetPds;
        Assert.notNull((Object)source, (String)"Source must not be null");
        Assert.notNull((Object)target, (String)"Target must not be null");
        ArrayList<String> ignorePropertyList = new ArrayList<String>();
        ignorePropertyList.addAll(Arrays.asList(IGNORE_PROPERTIES));
        if (ignoreList != null && ignoreList.length != 0) {
            ignorePropertyList.addAll(Arrays.asList(ignoreList));
        }
        Class<?> actualEditable = target.getClass();
        for (PropertyDescriptor targetPd : targetPds = BeanUtils.getPropertyDescriptors(actualEditable)) {
            PropertyDescriptor sourcePd;
            if (targetPd.getWriteMethod() == null || (sourcePd = BeanUtils.getPropertyDescriptor(source.getClass(), (String)targetPd.getName())) == null || sourcePd.getReadMethod() == null || ignorePropertyList.contains(targetPd.getName())) continue;
            try {
                Method readMethod = sourcePd.getReadMethod();
                if (!Modifier.isPublic(readMethod.getDeclaringClass().getModifiers())) {
                    readMethod.setAccessible(true);
                }
                Object value = readMethod.invoke(source, new Object[0]);
                Method writeMethod = targetPd.getWriteMethod();
                if (!Modifier.isPublic(writeMethod.getDeclaringClass().getModifiers())) {
                    writeMethod.setAccessible(true);
                }
                writeMethod.invoke(target, value);
            }
            catch (Throwable ex) {
                throw new FatalBeanException("Could not copy properties '" + targetPd.getName() + "' from source to target", ex);
            }
        }
    }

    public static void copyProperties(Object source, Object target) throws BeansException {
        PropertyDescriptor[] targetPds;
        Assert.notNull((Object)source, (String)"Source must not be null");
        Assert.notNull((Object)target, (String)"Target must not be null");
        Class<?> actualEditable = target.getClass();
        for (PropertyDescriptor targetPd : targetPds = BeanUtils.getPropertyDescriptors(actualEditable)) {
            PropertyDescriptor sourcePd;
            if (targetPd.getWriteMethod() == null || (sourcePd = BeanUtils.getPropertyDescriptor(source.getClass(), (String)targetPd.getName())) == null || sourcePd.getReadMethod() == null) continue;
            try {
                Object value;
                Method readMethod = sourcePd.getReadMethod();
                if (!Modifier.isPublic(readMethod.getDeclaringClass().getModifiers())) {
                    readMethod.setAccessible(true);
                }
                if ((value = readMethod.invoke(source, new Object[0])) == null || "".equals(value)) continue;
                Method writeMethod = targetPd.getWriteMethod();
                if (!Modifier.isPublic(writeMethod.getDeclaringClass().getModifiers())) {
                    writeMethod.setAccessible(true);
                }
                writeMethod.invoke(target, value);
            }
            catch (Throwable ex) {
                throw new FatalBeanException("Could not copy properties '" + targetPd.getName() + "' from source to target", ex);
            }
        }
    }

    public static Map<String, Object> bean2Map(Object obj, boolean isAllowNull) {
        if (obj == null) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            PropertyDescriptor[] propertyDescriptors;
            BeanInfo beanInfo = Introspector.getBeanInfo(obj.getClass());
            for (PropertyDescriptor property : propertyDescriptors = beanInfo.getPropertyDescriptors()) {
                String key = property.getName();
                if (key.equals("class")) continue;
                Method getter = property.getReadMethod();
                Object value = getter.invoke(obj, new Object[0]);
                if (!isAllowNull && (value == null || value.toString().isEmpty())) continue;
                map.put(key, value);
            }
        }
        catch (Exception e) {
            System.out.println("transBean2Map Error " + e);
        }
        return map;
    }

    public static void map2Bean(Map<String, Object> targetMap, Object obj) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (String key : targetMap.keySet()) {
            Object value = targetMap.get(key);
            map.put(StringUtils.lineToHump(key), value);
        }
        try {
            PropertyDescriptor[] propertyDescriptors;
            BeanInfo beanInfo = Introspector.getBeanInfo(obj.getClass());
            for (PropertyDescriptor property : propertyDescriptors = beanInfo.getPropertyDescriptors()) {
                String key = property.getName();
                if (!map.containsKey(key)) continue;
                try {
                    Object value = map.get(key);
                    Method setter = property.getWriteMethod();
                    setter.invoke(obj, value);
                }
                catch (Exception e) {
                    throw new RRException("\u5b9e\u4f53\u8f6c\u6362\u9519\u8bef:" + key);
                }
            }
        }
        catch (Exception e) {
            e.getStackTrace();
            throw new RRException("\u6570\u636e\u8f6c\u6362\u5f02\u5e38\uff01");
        }
    }
}

