/*
 * Decompiled with CFR 0.152.
 */
package com.kmall.common.oss;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.kmall.common.oss.CloudStorageConfig;
import com.kmall.common.oss.CloudStorageService;
import com.kmall.common.utils.RRException;
import com.qcloud.cos.COSClient;
import com.qcloud.cos.ClientConfig;
import com.qcloud.cos.request.UploadFileRequest;
import com.qcloud.cos.sign.Credentials;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.springframework.web.multipart.MultipartFile;

public class QcloudCloudStorageService
extends CloudStorageService {
    private COSClient client;

    public QcloudCloudStorageService(CloudStorageConfig config) {
        this.config = config;
        this.init();
    }

    private void init() {
        Credentials credentials = new Credentials((long)this.config.getQcloudAppId().intValue(), this.config.getQcloudSecretId(), this.config.getQcloudSecretKey());
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.setRegion(this.config.getQcloudRegion());
        this.client = new COSClient(clientConfig, credentials);
    }

    @Override
    public String upload(MultipartFile file) throws Exception {
        String fileName = file.getOriginalFilename();
        String prefix = fileName.substring(fileName.lastIndexOf(".") + 1);
        return this.upload(file.getBytes(), this.getPath(this.config.getAliyunPrefix()) + "." + prefix);
    }

    @Override
    public String upload(byte[] data, String path) {
        UploadFileRequest request;
        String response;
        JSONObject jsonObject;
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        if ((jsonObject = JSON.parseObject((String)(response = this.client.uploadFile(request = new UploadFileRequest(this.config.getQcloudBucketName(), path, data))))).getIntValue("code") != 0) {
            throw new RRException("\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25\uff0c" + jsonObject.getString("message"));
        }
        return this.config.getQcloudDomain() + path;
    }

    @Override
    public String upload(InputStream inputStream, String path) {
        try {
            byte[] data = IOUtils.toByteArray((InputStream)inputStream);
            return this.upload(data, path);
        }
        catch (IOException e) {
            throw new RRException("\u4e0a\u4f20\u6587\u4ef6\u5931\u8d25", e);
        }
    }
}

