/*
 * Decompiled with CFR 0.152.
 */
package com.kmall.common.oss;

import com.aliyun.oss.OSSClient;
import com.kmall.common.oss.CloudStorageConfig;
import com.kmall.common.oss.CloudStorageService;
import com.kmall.common.utils.RRException;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.springframework.web.multipart.MultipartFile;

public class AliyunCloudStorageService
extends CloudStorageService {
    private OSSClient client;

    public AliyunCloudStorageService(CloudStorageConfig config) {
        this.config = config;
        this.init();
    }

    private void init() {
        this.client = new OSSClient(this.config.getAliyunEndPoint(), this.config.getAliyunAccessKeyId(), this.config.getAliyunAccessKeySecret());
    }

    @Override
    public String upload(MultipartFile file) throws Exception {
        String fileName = file.getOriginalFilename();
        String prefix = fileName.substring(fileName.lastIndexOf(".") + 1);
        return this.upload(file.getBytes(), this.getPath(this.config.getAliyunPrefix()) + "." + prefix);
    }

    @Override
    public String upload(byte[] data, String path) {
        return this.upload(new ByteArrayInputStream(data), path);
    }

    @Override
    public String upload(InputStream inputStream, String path) {
        try {
            this.client.putObject(this.config.getAliyunBucketName(), path, inputStream);
        }
        catch (Exception e) {
            throw new RRException("\u4e0a\u4f20\u6587\u4ef6\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e\u4fe1\u606f", e);
        }
        return this.config.getAliyunDomain() + "/" + path;
    }
}

