/*
 * Decompiled with CFR 0.152.
 */
package com.kmall.common.manager.websocket;

import com.kmall.common.manager.websocket.Callback;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.java_websocket.WebSocket;
import org.java_websocket.client.WebSocketClient;
import org.java_websocket.handshake.ServerHandshake;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WsInvoker {
    private static final Logger logger = LoggerFactory.getLogger(WsInvoker.class);
    static Map<String, WebSocketClient> clients = new ConcurrentHashMap<String, WebSocketClient>();

    public static void invoke(String contents, String url, final Callback onSuccess, final Callback onError) {
        WebSocketClient client = clients.get(url);
        if (client != null && client.isConnecting() && client.isOpen()) {
            client.send(contents);
        } else {
            try {
                client = new WebSocketClient(new URI(url)){

                    public void onOpen(ServerHandshake handshakedata) {
                    }

                    public void onMessage(String message) {
                        if (onSuccess != null) {
                            onSuccess.run(message);
                        }
                    }

                    public void onMessage(ByteBuffer bytes) {
                        try {
                            if (onSuccess != null) {
                                onSuccess.run(new String(bytes.array(), "utf-8"));
                            }
                        }
                        catch (UnsupportedEncodingException e) {
                            logger.error("\u8fd4\u56de\u4e0d\u652f\u6301\u7684\u7f16\u7801\u6d88\u606f");
                            e.printStackTrace();
                        }
                    }

                    public void onClose(int code, String reason, boolean remote) {
                    }

                    public void onError(Exception ex) {
                        if (onError != null) {
                            onError.run(ex);
                        }
                    }
                };
                client.connect();
                Integer timeOut = 180000;
                Integer step = 10;
                Integer count = 0;
                while (!WebSocket.READYSTATE.OPEN.equals((Object)client.getReadyState())) {
                    try {
                        count = count + step;
                        Thread.sleep(step.intValue());
                        if (count < timeOut) continue;
                        onError.run(new Exception("WS\u670d\u52a1\u5668\u8fde\u63a5\u8d85\u65f6\uff01\u6216\u670d\u52a1\u5668\u5df2\u7ecf\u5173\u95ed"));
                        break;
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                client.send(contents);
                clients.put(url, client);
            }
            catch (URISyntaxException e) {
                logger.error("\u8bf7\u6c42url\u8bed\u6cd5\u9519\u8bef");
                e.printStackTrace();
            }
        }
    }
}

