/*
 * Decompiled with CFR 0.152.
 */
package com.kmall.common.fileserver.util;

import com.kmall.common.fileserver.common.NameValuePair;
import com.kmall.common.fileserver.fastdfs.ClientGlobal;
import com.kmall.common.fileserver.fastdfs.FileInfo;
import com.kmall.common.fileserver.fastdfs.StorageClient;
import com.kmall.common.fileserver.fastdfs.StorageServer;
import com.kmall.common.fileserver.fastdfs.TrackerClient;
import com.kmall.common.fileserver.fastdfs.TrackerServer;
import com.kmall.common.fileserver.util.FastDFSFile;
import java.io.IOException;
import java.io.Serializable;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.multipart.MultipartFile;

public class FileManager
implements Serializable {
    private static final long serialVersionUID = -9042217554595446459L;
    public static final String PROTOCOL = "http://";
    public static final String SEPARATOR = "/";
    public static final String COLON = ":";
    public static final String CLIENT_CONFIG_FILE = "conf/fastdfs.properties";
    private static Log logger = LogFactory.getLog(FileManager.class);
    private static TrackerClient trackerClient;
    private static TrackerServer trackerServer;
    private static StorageServer storageServer;
    private static StorageClient storageClient;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String upload(MultipartFile attach) {
        String[] uploadResults = null;
        String ext = attach.getOriginalFilename().substring(attach.getOriginalFilename().lastIndexOf(".") + 1);
        try {
            FastDFSFile file = new FastDFSFile(attach.getBytes(), ext);
            NameValuePair[] meta_list = new NameValuePair[]{new NameValuePair("fileName", attach.getOriginalFilename()), new NameValuePair("fileLength", String.valueOf(attach.getSize())), new NameValuePair("fileExt", ext), new NameValuePair("fileAuthor", ClientGlobal.file_author)};
            StorageClient storageClient = FileManager.storageClient;
            synchronized (storageClient) {
                uploadResults = FileManager.storageClient.upload_file(file.getContent(), file.getExt(), meta_list);
            }
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        void groupName = uploadResults[0];
        void remoteFileName = uploadResults[1];
        String httpAddr = ClientGlobal.http_tracket_nginx_addr;
        String httpPort = ClientGlobal.http_tracket_server_port;
        String fileAbsolutePath = PROTOCOL + httpAddr + COLON + httpPort + SEPARATOR + (String)groupName + SEPARATOR + (String)remoteFileName;
        return fileAbsolutePath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String upload(String originalFileName, byte[] content, String fileLength) {
        String[] uploadResults = null;
        String ext = originalFileName.substring(originalFileName.lastIndexOf(".") + 1);
        try {
            FastDFSFile file = new FastDFSFile(content, ext);
            NameValuePair[] meta_list = new NameValuePair[]{new NameValuePair("fileName", originalFileName), new NameValuePair("fileLength", fileLength), new NameValuePair("fileExt", ext), new NameValuePair("fileAuthor", ClientGlobal.file_author)};
            StorageClient storageClient = FileManager.storageClient;
            synchronized (storageClient) {
                uploadResults = FileManager.storageClient.upload_file(file.getContent(), file.getExt(), meta_list);
            }
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        void groupName = uploadResults[0];
        void remoteFileName = uploadResults[1];
        String httpAddr = ClientGlobal.http_tracket_nginx_addr;
        String httpPort = ClientGlobal.http_tracket_server_port;
        String fileAbsolutePath = PROTOCOL + httpAddr + COLON + httpPort + SEPARATOR + (String)groupName + SEPARATOR + (String)remoteFileName;
        return fileAbsolutePath;
    }

    public static ResponseEntity<byte[]> download(String filePath, String fileName) {
        byte[] content = null;
        HttpHeaders headers = new HttpHeaders();
        String substr = filePath.substring(filePath.indexOf("group"));
        String groupName = substr.split(SEPARATOR)[0];
        String remoteFileName = substr.substring(substr.indexOf(SEPARATOR) + 1);
        String specFileName = substr.substring(substr.indexOf("."));
        try {
            fileName = fileName == null || fileName.trim().equals("") ? UUID.randomUUID() + specFileName : fileName + specFileName;
            content = storageClient.download_file(groupName, remoteFileName);
            headers.setContentDispositionFormData("attachment", new String(fileName.getBytes("UTF-8"), "iso-8859-1"));
            headers.setContentType(MediaType.APPLICATION_OCTET_STREAM);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return new ResponseEntity(content, (MultiValueMap)headers, HttpStatus.CREATED);
    }

    public static FileInfo getFile(String filePath) {
        String substr = filePath.substring(filePath.indexOf("group"));
        String groupName = substr.split(SEPARATOR)[0];
        String remoteFileName = substr.substring(substr.indexOf(SEPARATOR) + 1);
        try {
            return storageClient.get_file_info(groupName, remoteFileName);
        }
        catch (IOException e) {
            logger.error((Object)"IO Exception: Get File from Fast DFS failed", (Throwable)e);
        }
        catch (Exception e) {
            logger.error((Object)"Non IO Exception: Get File from Fast DFS failed", (Throwable)e);
        }
        return null;
    }

    static {
        System.out.println("FileManager");
        try {
            String fdfsClientConfigFilePath = CLIENT_CONFIG_FILE;
            ClientGlobal.init(fdfsClientConfigFilePath);
            trackerClient = new TrackerClient();
            trackerServer = trackerClient.getConnection();
            storageClient = new StorageClient(trackerServer, storageServer);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

