/*
 * Decompiled with CFR 0.152.
 */
package com.kmall.common.advice;

import com.kmall.common.utils.DateUtils;
import java.beans.PropertyEditorSupport;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.StringUtils;

public class CustomDateEditor
extends PropertyEditorSupport {
    private static final Log logger = LogFactory.getLog(CustomDateEditor.class);
    private final DateFormat dateFormat;
    private final boolean allowEmpty;

    public CustomDateEditor(DateFormat dateFormat, boolean allowEmpty) {
        this.dateFormat = dateFormat;
        this.allowEmpty = allowEmpty;
    }

    public CustomDateEditor() {
        this.dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        this.allowEmpty = true;
    }

    public CustomDateEditor(DateFormat dateFormat, boolean allowEmpty, int exactDateLength) {
        this.dateFormat = dateFormat;
        this.allowEmpty = allowEmpty;
    }

    @Override
    public void setAsText(String text) throws IllegalArgumentException {
        logger.debug((Object)("*****\u8f6c\u6362\u65e5\u671f\u5b57\u7b26\u4e32:" + text + "*****"));
        if (this.allowEmpty && !StringUtils.hasText((String)text)) {
            this.setValue(null);
            return;
        }
        try {
            this.setValue(this.dateFormat.parse(text));
        }
        catch (ParseException ex) {
            try {
                String style = DateUtils.getDateFormat(text);
                if (!StringUtils.isEmpty((Object)style)) {
                    SimpleDateFormat df = new SimpleDateFormat(style);
                    df.setLenient(false);
                    this.setValue(df.parse(text));
                }
            }
            catch (ParseException e) {
                logger.error((Object)"****** \u65e5\u671f\u7c7b\u578b\u8f6c\u6362\u9519\u8bef,\u4ec5\u8bb0\u5f55,\u5fc5\u8981\u65f6\u67e5\u8be2\u6570\u636e****");
            }
        }
    }

    @Override
    public String getAsText() {
        Date value = (Date)this.getValue();
        return value != null ? this.dateFormat.format(value) : "";
    }
}

