/*
 * Decompiled with CFR 0.152.
 */
package com.kmall.common;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.AbstractApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.web.context.ContextLoader;

public abstract class SpringApplicationContextSupport {
    private static final Logger logger = LoggerFactory.getLogger(SpringApplicationContextSupport.class);
    private static AbstractApplicationContext applicationContext;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final AbstractApplicationContext loadApplicationContext(String contextConfigPath) {
        Logger logger = SpringApplicationContextSupport.logger;
        synchronized (logger) {
            if (applicationContext == null) {
                SpringApplicationContextSupport.logger.info("Initializing Spring context...");
                applicationContext = new ClassPathXmlApplicationContext(contextConfigPath);
                SpringApplicationContextSupport.logger.info("Spring context initialized!");
                applicationContext.registerShutdownHook();
            }
        }
        return applicationContext;
    }

    public static final ApplicationContext getApplicationContext() {
        if (applicationContext == null) {
            return ContextLoader.getCurrentWebApplicationContext();
        }
        return applicationContext;
    }
}

