/*
 * Decompiled with CFR 0.152.
 */
package org.jxls.reader;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellReference;
import org.jxls.reader.BaseBlockReader;
import org.jxls.reader.BeanCellMapping;
import org.jxls.reader.ConvertUtilsBeanProvider;
import org.jxls.reader.ConvertUtilsBeanProviderDelegate;
import org.jxls.reader.ReaderConfig;
import org.jxls.reader.SectionCheck;
import org.jxls.reader.SimpleBlockReader;
import org.jxls.reader.XLSDataReadException;
import org.jxls.reader.XLSReadMessage;
import org.jxls.reader.XLSReadStatus;
import org.jxls.reader.XLSRowCursor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleBlockReaderImpl
extends BaseBlockReader
implements SimpleBlockReader {
    protected final Log log = LogFactory.getLog(this.getClass());
    List<BeanCellMapping> beanCellMappings = new ArrayList<BeanCellMapping>();
    SectionCheck sectionCheck;
    ConvertUtilsBeanProviderDelegate convertUtilsProvider = new ConvertUtilsBeanProviderDelegate();

    public SimpleBlockReaderImpl() {
    }

    public SimpleBlockReaderImpl(int startRow, int endRow, List<BeanCellMapping> beanCellMappings) {
        this.startRow = startRow;
        this.endRow = endRow;
        this.beanCellMappings = new ArrayList<BeanCellMapping>(beanCellMappings);
        for (BeanCellMapping beanCellMapping : this.beanCellMappings) {
            beanCellMapping.setConvertUtilsProvider(this.convertUtilsProvider);
        }
    }

    public SimpleBlockReaderImpl(int startRow, int endRow) {
        this.startRow = startRow;
        this.endRow = endRow;
    }

    @Override
    public void setConvertUtilsBeanProvider(ConvertUtilsBeanProvider provider) {
        this.convertUtilsProvider.setDelegate(provider);
    }

    @Override
    public XLSReadStatus read(XLSRowCursor cursor, Map beans) {
        this.readStatus.clear();
        int currentRowNum = cursor.getCurrentRowNum();
        int rowShift = currentRowNum - this.startRow;
        Iterator<BeanCellMapping> iterator = this.beanCellMappings.iterator();
        while (iterator.hasNext()) {
            BeanCellMapping beanCellMapping;
            BeanCellMapping mapping = beanCellMapping = iterator.next();
            try {
                String dataString = this.readCellString(cursor.getSheet(), mapping.getRow() + rowShift, mapping.getCol());
                mapping.populateBean(dataString, beans);
            }
            catch (Exception e) {
                String message = "Can't read cell " + this.getCellName(mapping, rowShift) + " on " + cursor.getSheetName() + " spreadsheet";
                this.readStatus.addMessage(new XLSReadMessage(message, e));
                if (ReaderConfig.getInstance().isSkipErrors()) {
                    if (!this.log.isWarnEnabled()) continue;
                    this.log.warn((Object)message);
                    continue;
                }
                this.readStatus.setStatusOK(false);
                throw new XLSDataReadException(this.getCellName(mapping, rowShift), "Can't read cell " + this.getCellName(mapping, rowShift) + " on " + cursor.getSheetName() + " spreadsheet", this.readStatus, e);
            }
        }
        cursor.setCurrentRowNum(this.endRow + rowShift);
        return this.readStatus;
    }

    private String readCellString(Sheet sheet, int rowNum, short cellNum) {
        Cell cell = this.getCell(sheet, rowNum, cellNum);
        return this.getCellString(cell);
    }

    private String getCellString(Cell cell) {
        String dataString = null;
        if (cell != null) {
            switch (cell.getCellTypeEnum()) {
                case STRING: {
                    dataString = cell.getRichStringCellValue().getString();
                    break;
                }
                case NUMERIC: {
                    dataString = this.readNumericCell(cell);
                    break;
                }
                case BOOLEAN: {
                    dataString = Boolean.toString(cell.getBooleanCellValue());
                    break;
                }
                case BLANK: {
                    break;
                }
                case ERROR: {
                    break;
                }
                case FORMULA: {
                    try {
                        dataString = this.readNumericCell(cell);
                    }
                    catch (Exception e1) {
                        this.log.info((Object)("Failed to read formula cell as numeric. Next to try as string. Cell=" + cell.toString()));
                        try {
                            dataString = cell.getRichStringCellValue().getString();
                            this.log.info((Object)("Successfully read formula cell as string. Value=" + dataString));
                        }
                        catch (Exception e2) {
                            this.log.warn((Object)("Failed to read formula cell as numeric or string. Cell=" + cell.toString()));
                        }
                    }
                    break;
                }
            }
        }
        return dataString;
    }

    private String readNumericCell(Cell cell) {
        double value = cell.getNumericCellValue();
        String dataString = (double)((int)value) == value ? Integer.toString((int)value) : Double.toString(cell.getNumericCellValue());
        return dataString;
    }

    private String getCellName(BeanCellMapping mapping, int rowShift) {
        CellReference currentCellRef = new CellReference(mapping.getRow() + rowShift, (int)mapping.getCol(), false, false);
        return currentCellRef.formatAsString();
    }

    public SectionCheck getLoopBreakCondition() {
        return this.sectionCheck;
    }

    public void setLoopBreakCondition(SectionCheck sectionCheck) {
        this.sectionCheck = sectionCheck;
    }

    @Override
    public void addMapping(BeanCellMapping mapping) {
        mapping.setConvertUtilsProvider(this.convertUtilsProvider);
        this.beanCellMappings.add(mapping);
    }

    @Override
    public List getMappings() {
        return this.beanCellMappings;
    }

    private Cell getCell(Sheet sheet, int rowNum, int cellNum) {
        Row row = sheet.getRow(rowNum);
        if (row == null) {
            return null;
        }
        return row.getCell(cellNum);
    }

    static {
        ReaderConfig.getInstance();
    }
}

