/*
 * Decompiled with CFR 0.152.
 */
package com.cherry.sdk.controller;

import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.util.Log;
import com.cherry.sdk.controller.command.Command;
import com.cherry.sdk.controller.command.RequestQueue;
import com.cherry.sdk.controller.data.PackageConfig;
import com.cherry.sdk.controller.module.SerialModule;
import com.cherry.sdk.controller.utils.SerialDataUtils;

public class SerialController {
    private static final String TAG = SerialController.class.getSimpleName();
    private static final SerialController instance = new SerialController();
    private static final int MAX_CMD_IN_QUEUE = 20;
    private static final int COMMAND_DELAY = 1000;
    private RequestQueue mQueue = new RequestQueue();
    private WriteHandler writeHandler;
    private final HandlerThread writeThread = new HandlerThread("writeSerial");
    private SerialModule serialModule;

    public static SerialController getInstance() {
        return instance;
    }

    private SerialController() {
        this.writeThread.start();
        this.writeHandler = new WriteHandler(this.writeThread.getLooper());
        this.serialModule = new SerialModule(PackageConfig.device_485, PackageConfig.uartRtsIO, PackageConfig.revertUartRts, PackageConfig.bandRate);
        this.writeHandler.sendEmptyMessage(0);
    }

    public void send(Command cmd) {
        Log.d((String)TAG, (String)("send" + SerialDataUtils.ByteArrToHex(cmd.bys[0])));
        if (cmd != null) {
            this.mQueue.push(cmd);
        } else {
            Log.d((String)TAG, (String)"SerialController --> receive command is null");
        }
    }

    public boolean busy() {
        return this.mQueue.size() >= 20;
    }

    public void close() {
        if (this.writeHandler != null) {
            this.writeHandler.getLooper().quit();
        }
        if (this.writeThread != null) {
            this.writeThread.quit();
        }
        this.serialModule.close();
    }

    private class WriteHandler
    extends Handler {
        public WriteHandler(Looper looper) {
            super(looper);
        }

        public void handleMessage(Message msg) {
            super.handleMessage(msg);
            Command cmd = SerialController.this.mQueue.top();
            if (cmd == null) {
                this.recheck(500);
                return;
            }
            if (cmd.callback == null) {
                this.recheck(500);
                return;
            }
            Log.e((String)TAG, (String)"proc cmd");
            this.transaction(cmd);
            SerialController.this.mQueue.remove(cmd);
            this.recheck(1000);
        }

        private void recheck(int ms) {
            SerialController.this.writeHandler.sendEmptyMessageDelayed(0, ms);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void transaction(Command cmd) {
            SerialController serialController = SerialController.getInstance();
            synchronized (serialController) {
                int cmdCount = cmd.bys.length;
                final int[] code = new int[1];
                final byte[][] resultBytesArray = new byte[cmdCount][];
                int i = 0;
                while (i < cmdCount) {
                    final byte[] cmdBytes = cmd.bys[i];
                    final int finalI = i++;
                    SerialController.this.serialModule.write(cmdBytes, new SerialModule.HandleData(){

                        @Override
                        public boolean handleData(byte[] bytes) {
                            if (SerialDataUtils.checkIfZero(bytes) || bytes.length == 0) {
                                return false;
                            }
                            code[0] = !Command.checkLRC(bytes) ? 1704 : ((cmdBytes[3] == 2 || cmdBytes[3] == 18) && bytes[4] == 0 ? 1705 : 0);
                            resultBytesArray[finalI] = bytes;
                            return true;
                        }

                        @Override
                        public void timeout() {
                            code[0] = 1701;
                        }

                        @Override
                        public void error(String s) {
                            Log.d((String)TAG, (String)s);
                            code[0] = 1703;
                        }
                    });
                    if (code[0] != 0) break;
                }
                cmd.callback.handleResult(code[0], resultBytesArray);
            }
        }
    }
}

