/*
 * Decompiled with CFR 0.152.
 */
package com.cherry.sdk.controller;

import android.util.Log;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;

public class LightManager {
    private static final String LED_CTL_PATH = "/sys/class/zh_gpio_out/out";
    private static final String[] LED_OFF_VAL = new String[]{"2", "4", "6", "8"};
    private static final String[] LED_ON_VAL = new String[]{"5", "7"};
    public static final int MODE_ON = 0;
    public static final int MODE_OFF = 1;
    public static final int MODE_WHITE_ON = 2;
    public static final int MODE_WHITE_OFF = 3;
    public static final int MODE_IR_ON = 4;
    public static final int MODE_IR_OFF = 5;
    public static final int MODE_RED = 6;
    public static final int MODE_GREEN = 7;

    public void setLedMode(int mode) {
        switch (mode) {
            case 0: {
                for (String val : LED_ON_VAL) {
                    LightManager.ctlLed(val);
                }
                break;
            }
            case 1: {
                for (String val : LED_OFF_VAL) {
                    LightManager.ctlLed(val);
                }
                break;
            }
            case 2: {
                LightManager.ctlLed("5");
                break;
            }
            case 3: {
                LightManager.ctlLed("6");
                break;
            }
            case 4: {
                LightManager.ctlLed("7");
                break;
            }
            case 5: {
                LightManager.ctlLed("8");
                break;
            }
            case 7: {
                LightManager.ctlLed("3");
                break;
            }
            case 6: {
                LightManager.ctlLed("1");
            }
        }
    }

    private static void ctlLed(String val) {
        File file = new File(LED_CTL_PATH);
        if (!file.exists() || !file.canWrite()) {
            Log.w((String)"LED", (String)"LED ctl path is not exists or can not write!!");
            return;
        }
        try {
            FileOutputStream fout = new FileOutputStream(file);
            PrintWriter pWriter = new PrintWriter(fout);
            pWriter.println(val);
            pWriter.flush();
            Log.d((String)"LED", (String)("write led val:" + val));
            pWriter.close();
            fout.close();
        }
        catch (IOException re) {
            Log.d((String)"LED", (String)("write error:" + re));
        }
    }
}

