/*
 * Decompiled with CFR 0.152.
 */
package com.cherry.sdk.controller.utils;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class SerialDataUtils {
    private static String hexStr = "0123456789ABCDEF";
    private static String[] binaryArray = new String[]{"0000", "0001", "0010", "0011", "0100", "0101", "0110", "0111", "1000", "1001", "1010", "1011", "1100", "1101", "1110", "1111"};
    private static int[] hexStrArray = new int[]{8, 10, 12, 14};

    public static int isOdd(int num) {
        return num & 1;
    }

    public static int HexToInt(String inHex) {
        return Integer.parseInt(inHex, 16);
    }

    public static byte HexToByte(String inHex) {
        return (byte)Integer.parseInt(inHex, 16);
    }

    public static String Byte2Hex(Byte inByte) {
        return String.format("%02x", inByte).toUpperCase();
    }

    public static String ByteArrToHex(byte[] inBytArr) {
        StringBuilder strBuilder = new StringBuilder();
        for (byte valueOf : inBytArr) {
            strBuilder.append(SerialDataUtils.Byte2Hex(valueOf));
            strBuilder.append(" ");
        }
        return strBuilder.toString();
    }

    public static String ByteArrToHex(byte[] inBytArr, int offset, int byteCount) {
        StringBuilder strBuilder = new StringBuilder();
        int j = byteCount;
        for (int i = offset; i < j; ++i) {
            strBuilder.append(SerialDataUtils.Byte2Hex(inBytArr[i]));
        }
        return strBuilder.toString();
    }

    public static byte[] HexToByteArr(String inHex) {
        byte[] result;
        int hexlen = (inHex = inHex.replaceAll(" ", "")).length();
        if (SerialDataUtils.isOdd(hexlen) == 1) {
            result = new byte[++hexlen / 2];
            inHex = "0" + inHex;
        } else {
            result = new byte[hexlen / 2];
        }
        int j = 0;
        for (int i = 0; i < hexlen; i += 2) {
            result[j] = SerialDataUtils.HexToByte(inHex.substring(i, i + 2));
            ++j;
        }
        return result;
    }

    public static byte checkBysAnd(byte ... bys) {
        byte b = -1;
        for (byte by : bys) {
            b = (byte)(by & b);
        }
        return b;
    }

    public static byte checkBysXOR(byte ... bys) {
        byte b = 0;
        for (byte by : bys) {
            b = (byte)(by ^ b);
        }
        return b;
    }

    public static byte[] parseData(int by1, int by2, int by3) {
        byte[] bys;
        bys = new byte[]{-86, (byte)by1, (byte)by2, (byte)by3, -1, 0, SerialDataUtils.checkBysXOR(bys[1], bys[2], bys[3], bys[4]), -33};
        return bys;
    }

    public static boolean checkIfZero(byte[] data) {
        for (byte b : data) {
            if (b == 0) continue;
            return false;
        }
        return true;
    }

    public static String bytes2BinStr(byte[] bArray) {
        String outStr = "";
        int pos = 0;
        for (byte b : bArray) {
            pos = (b & 0xF0) >> 4;
            outStr = outStr + binaryArray[pos];
            pos = b & 0xF;
            outStr = outStr + binaryArray[pos];
        }
        return outStr;
    }

    public static String bin2HexStr(byte[] bytes) {
        String result = "";
        String hex = "";
        for (int i = 0; i < bytes.length; ++i) {
            hex = String.valueOf(hexStr.charAt((bytes[i] & 0xF0) >> 4));
            hex = hex + String.valueOf(hexStr.charAt(bytes[i] & 0xF));
            result = result + hex;
        }
        return result;
    }

    public static byte[] hexStr2BinArr(String hexString) {
        int len = hexString.length() / 2;
        byte[] bytes = new byte[len];
        byte high = 0;
        byte low = 0;
        for (int i = 0; i < len; ++i) {
            high = (byte)(hexStr.indexOf(hexString.charAt(2 * i)) << 4);
            low = (byte)hexStr.indexOf(hexString.charAt(2 * i + 1));
            bytes[i] = (byte)(high | low);
        }
        return bytes;
    }

    public static String hexStr2BinStr(String hexString) {
        return SerialDataUtils.bytes2BinStr(SerialDataUtils.hexStr2BinArr(hexString));
    }

    public static String hexStr2Arr(byte[] bys) throws JSONException {
        String result = "";
        int count = 0;
        JSONArray jsonArray = new JSONArray();
        if (bys.length != 14) {
            return result;
        }
        String data = SerialDataUtils.ByteArrToHex(bys);
        data = data.replaceAll(" ", "");
        for (int z = 0; z < 4; ++z) {
            String countStr = binaryArray[hexStr.indexOf(data.substring(hexStrArray[z], hexStrArray[z] + 1))];
            String countStr2 = countStr + binaryArray[hexStr.indexOf(data.substring(hexStrArray[z] + 1, hexStrArray[z] + 2))];
            for (int j = countStr2.length(); j > 0; --j) {
                ++count;
                String c = countStr2.substring(j - 1, j);
                JSONObject jsonObject = new JSONObject();
                if (c.equals("0")) {
                    jsonObject.put("section", (int)bys[1]);
                    jsonObject.put("port", count);
                    jsonObject.put("unlocked", false);
                } else {
                    jsonObject.put("section", (int)bys[1]);
                    jsonObject.put("port", count);
                    jsonObject.put("unlocked", true);
                }
                jsonArray.put((Object)jsonObject);
            }
        }
        result = jsonArray.toString();
        return result;
    }
}

